/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.polynomes.test;

import org.ctom.hulis.polynomes.Polynomial;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.hulis.util.math.Complex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PolynomialTest {
    private Polynomial p;
    private Polynomial q;
    private Polynomial r;
    private Polynomial s;
    private static final double THRS = 1.0E-10;

    @Before
    public void setUp() throws Exception {
        this.p = new Polynomial(new double[]{2.0, -1.0, 1.0});
        this.q = new Polynomial(new double[]{1.0, 1.0, 1.0});
        this.r = new Polynomial(new double[]{-3.0, -2.0, -2.0, 1.0});
        this.s = new Polynomial(new double[]{-3.0, 1.0});
    }

    @Test
    public void testGetDegree() {
        Assert.assertTrue(this.p.getDegree() == 2);
    }

    @Test
    public void testGetCoefficients() {
        Assert.assertTrue(this.p.getCoefficients().length == 3);
        Assert.assertTrue(this.p.getCoefficients()[0] == 2.0);
        Assert.assertTrue(this.p.getCoefficients()[1] == -1.0);
        Assert.assertTrue(this.p.getCoefficients()[2] == 1.0);
    }

    @Test
    public void testGetCoeffOfDegree() {
        Assert.assertTrue(this.p.getCoeffOfDegree(0) == 2.0);
        Assert.assertTrue(this.p.getCoeffOfDegree(1) == -1.0);
        Assert.assertTrue(this.p.getCoeffOfDegree(2) == 1.0);
        Assert.assertTrue(this.p.getCoeffOfDegree(3) == 0.0);
    }

    @Test
    public void testToString() {
        String str = "x^2 -x +2.0";
        Assert.assertTrue("|" + this.p.toString() + "|==|" + str + "| ?" + this.p.toString().equals(str), this.p.toString().equals(str));
    }

    @Test
    public void testEval() {
        double x = -1.0;
        Assert.assertTrue(this.p.eval(x) == 4.0);
    }

    @Test
    public void testAdd() {
        Polynomial sum = this.p.add(this.q);
        Assert.assertTrue(sum.getCoeffOfDegree(0) == 3.0);
        Assert.assertTrue(sum.getCoeffOfDegree(1) == 0.0);
        Assert.assertTrue(sum.getCoeffOfDegree(2) == 2.0);
    }

    @Test
    public void testMultiply() {
        Polynomial prod = this.p.multiply(this.q);
        Assert.assertTrue(prod.getDegree() == 4);
        Assert.assertTrue(prod.getCoeffOfDegree(0) == 2.0);
        Assert.assertTrue(prod.getCoeffOfDegree(1) == 1.0);
        Assert.assertTrue(prod.getCoeffOfDegree(2) == 2.0);
        Assert.assertTrue(prod.getCoeffOfDegree(3) == 0.0);
        Assert.assertTrue(String.valueOf(prod.getCoeffOfDegree(4)), prod.getCoeffOfDegree(4) == 1.0);
    }

    @Test
    public void testFastEvalReal() {
        Assert.assertTrue(this.p.fastEval(2.0, 2)[0] == 4.0);
        Assert.assertTrue(this.p.fastEval(2.0, 2)[1] == 3.0);
        Assert.assertTrue(this.p.fastEval(2.0, 2)[2] == 2.0);
        Assert.assertTrue(this.q.fastEval(2.0, 2)[0] == 7.0);
        Assert.assertTrue(this.q.fastEval(2.0, 2)[1] == 5.0);
        Assert.assertTrue(this.q.fastEval(2.0, 2)[2] == 2.0);
    }

    @Test
    public void testFastEvalComplex() {
        HuckelIO.PrintIf(String.valueOf(this.p.toString()) + " : " + this.p.fastEval(new Complex(1.0, 1.0), 2)[0].toString());
        Assert.assertTrue(this.p.fastEval(new Complex(1.0, 1.0), 2)[0].getReal() == 1.0);
        Assert.assertTrue(this.p.fastEval(new Complex(1.0, 1.0), 2)[0].getImag() == 1.0);
    }

    @Test
    public void testDividePbyP() {
        Polynomial[] div = this.p.divide(this.p);
        Polynomial pq = div[0];
        Polynomial pr = div[1];
        Assert.assertTrue(pq.isSimilar(new Polynomial(new double[]{1.0}), 1.0E-10));
        Assert.assertTrue(pr.isSimilar(new Polynomial(new double[]{0.0}), 1.0E-10));
    }

    @Test
    public void testDivideQbyQ() {
        Polynomial[] div = this.q.divide(this.q);
        Polynomial qq = div[0];
        Polynomial qr = div[1];
        Assert.assertTrue(qq.isSimilar(new Polynomial(new double[]{1.0}), 1.0E-10));
        Assert.assertTrue(qr.isSimilar(new Polynomial(new double[]{0.0}), 1.0E-10));
    }

    @Test
    public void testDivideRbyR() {
        Polynomial[] div = this.r.divide(this.r);
        Polynomial rq = div[0];
        Polynomial rr = div[1];
        Assert.assertTrue(rq.isSimilar(new Polynomial(new double[]{1.0}), 1.0E-10));
        Assert.assertTrue(rr.isSimilar(new Polynomial(new double[]{0.0}), 1.0E-10));
    }

    @Test
    public void testDivideRbyQ() {
        Polynomial[] div = this.r.divide(this.q);
        Polynomial rq = div[0];
        Polynomial rr = div[1];
        Assert.assertTrue(rq.isSimilar(new Polynomial(new double[]{-3.0, 1.0}), 1.0E-10));
        Assert.assertTrue(rr.isSimilar(new Polynomial(new double[]{0.0}), 1.0E-10));
    }

    @Test
    public void testDivideRbyS() {
        Polynomial[] div = this.r.divide(this.s);
        Polynomial rq = div[0];
        Polynomial rr = div[1];
        Assert.assertTrue(rq.isSimilar(this.q, 1.0E-10));
        Assert.assertTrue(rr.isSimilar(new Polynomial(new double[]{0.0}), 1.0E-10));
    }
}

