/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import org.ctom.hulis.huckel.exception.ProjectionException;
import org.ctom.hulis.util.io.HuckelIO;

public class Projection {
    private Matrix Overlap;
    private Matrix OverlapWithStot;
    private double[] coeffs = null;
    private double[] weights = null;

    public Projection(Matrix overlap, Matrix overlapWithStot) throws ProjectionException {
        this.Overlap = overlap;
        this.OverlapWithStot = overlapWithStot;
        int size = this.Overlap.getColumnDimension();
        this.coeffs = new double[size];
        this.weights = new double[size];
        this.solve();
        this.computeWeights();
    }

    private void checkS() throws ProjectionException {
        EigenvalueDecomposition DiagonalisationOverlap = new EigenvalueDecomposition(this.Overlap);
        double[] valeursPropresSRe = DiagonalisationOverlap.getRealEigenvalues();
        double[] valeursPropresSIm = DiagonalisationOverlap.getImagEigenvalues();
        int size = valeursPropresSRe.length;
        int i2 = 0;
        while (i2 < size) {
            HuckelIO.PrintIf(String.valueOf(i2) + "eme valp = " + valeursPropresSRe[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < size) {
            if (valeursPropresSIm[i2] != 0.0) {
                throw new ProjectionException("Une valeur propre de S est imaginaire!");
            }
            if (Math.abs(valeursPropresSRe[i2]) <= 1.0E-5) {
                throw new ProjectionException("Une valeur propre de S est presque nulle!");
            }
            ++i2;
        }
    }

    private double computeNorm() {
        double norm = 0.0;
        int size = this.weights.length;
        int i2 = 0;
        while (i2 < size) {
            norm += this.weights[i2];
            ++i2;
        }
        return norm;
    }

    private void computeWeights() {
        int size = this.getCoeffs().length;
        int iphi1 = 0;
        while (iphi1 < size) {
            double weight = 0.0;
            int iphi2 = 0;
            while (iphi2 < size) {
                weight += this.getCoeffs()[iphi2] * this.Overlap.get(iphi1, iphi2);
                ++iphi2;
            }
            this.weights[iphi1] = weight *= this.getCoeffs()[iphi1];
            ++iphi1;
        }
        this.computeNorm();
    }

    public double[] getCoeffs() {
        return this.coeffs;
    }

    public double[] getNormalizedCoeffs() {
        double[] tab = this.getCoeffs();
        int size = tab.length;
        double sqrtNorm = Math.sqrt(this.getNorm());
        int i2 = 0;
        while (i2 < size) {
            int n = i2++;
            tab[n] = tab[n] / sqrtNorm;
        }
        return tab;
    }

    public double getNorm() {
        return this.computeNorm();
    }

    public double[] getNormalizedWeights() {
        double[] tab = this.getWeights();
        int size = tab.length;
        int i2 = 0;
        while (i2 < size) {
            int n = i2++;
            tab[n] = tab[n] / this.getNorm();
        }
        return tab;
    }

    public double[] getWeights() {
        return (double[])this.weights.clone();
    }

    public void setError() {
        int size = this.coeffs.length;
        int i2 = 0;
        while (i2 < size) {
            this.coeffs[i2] = Double.NaN;
            this.weights[i2] = Double.NaN;
            ++i2;
        }
    }

    private void solve() throws ProjectionException {
        try {
            this.checkS();
        }
        catch (ProjectionException e) {
            HuckelIO.PrintIf("Problem for solving the linear system");
            this.setError();
            e.printStackTrace();
            throw e;
        }
        Matrix solution = this.Overlap.solve(this.OverlapWithStot);
        int size = this.coeffs.length;
        int i2 = 0;
        while (i2 < size) {
            this.coeffs[i2] = solution.get(i2, 0);
            ++i2;
        }
    }

    public double getNewTau() {
        double tau = 0.0;
        double[] normalizedCoeffs = this.getCoeffs();
        int i2 = 0;
        while (i2 < normalizedCoeffs.length) {
            tau += normalizedCoeffs[i2] * this.OverlapWithStot.get(i2, 0);
            ++i2;
        }
        return tau;
    }
}

