/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.configS;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.ctom.hulis.huckel.CoupleLocal;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.ConfException;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.prefs.Preferences;
import org.ctom.hulis.util.configS.BondConf;
import org.ctom.hulis.util.configS.ConfComparator;
import org.ctom.hulis.util.configS.Masque;

public class Conf {
    private static TreeSet<Conf> List = null;
    private static ArrayList<Masque> masques = null;
    private static int MaxLevel;
    private static int nAtoms;
    private static final int TOP = 0;
    private static int[][] topology;
    private static int[] Zpi;
    private static Mesomery mesomery;
    private ArrayList<BondConf> bonds;
    private TreeSet<Integer> bondSignature = null;
    private int[] charge = null;
    private int[] conf = null;
    private int level;
    private ArrayList<Conf> next;

    static {
        topology = null;
        Zpi = null;
    }

    private static boolean areAdjacent(int iat, int jat) {
        return topology[iat][jat] == 1;
    }

    public static void setMesomery(Mesomery mesomery) {
        Conf.mesomery = mesomery;
    }

    private static int compareConf(int[] conf1, int[] conf2) {
        int rc = 0;
        int iat = 0;
        while (iat < nAtoms) {
            int diff = conf1[iat] - conf2[iat];
            if (diff != 0) {
                return diff;
            }
            ++iat;
        }
        return rc;
    }

    private static void genMasques(int charge) {
        masques = new Masque(nAtoms).getList(charge, Preferences.getNUM_CHARGE_SEPARATION());
    }

    public static final TreeSet<Conf> getList() {
        return List;
    }

    private static boolean isNew(Conf conf) {
        boolean rc = List.isEmpty();
        rc = List.contains(conf);
        return !rc;
    }

    public static int nMasque() {
        return masques.size();
    }

    private Conf(Conf model) {
        this.conf = (int[])model.conf.clone();
        this.charge = (int[])model.charge.clone();
        this.next = null;
        this.level = model.level;
        this.bondSignature = new TreeSet();
        Iterator<Object> iterator = model.bondSignature.iterator();
        while (iterator.hasNext()) {
            int bondval = iterator.next();
            this.bondSignature.add(bondval);
        }
        this.bonds = new ArrayList();
        for (BondConf bond : model.bonds) {
            this.bonds.add(bond);
        }
    }

    public Conf(StructureDelocalized skeleton) {
        this.level = 0;
        skeleton.updateTopology();
        int[][] topo = skeleton.getTopology();
        int nHuckelAtoms = skeleton.countHuckelAtoms();
        int[] nElecPi = skeleton.getZpi();
        int totalCharge = skeleton.getNbElecCharge();
        this.init(topo, nHuckelAtoms, nElecPi, totalCharge);
    }

    public Conf(int[][] topo, int nHuckelAtoms, int[] nElecPi, int totalCharge) {
        this.init(topo, nHuckelAtoms, nElecPi, totalCharge);
    }

    private void init(int[][] topo, int nHuckelAtoms, int[] nElecPi, int totalCharge) {
        if (topology == null) {
            topology = topo;
        }
        if (List == null) {
            ConfComparator confComparator = new ConfComparator();
            List = new TreeSet(confComparator);
        }
        this.next = null;
        nAtoms = nHuckelAtoms;
        this.conf = new int[nAtoms];
        int iat = 0;
        while (iat < nAtoms) {
            this.conf[iat] = 0;
            ++iat;
        }
        this.bonds = new ArrayList();
        this.bondSignature = new TreeSet();
        if (Zpi == null) {
            Zpi = nElecPi;
        }
        this.genNeutralConf();
        Conf.genMasques(-totalCharge);
        this.charge = new int[nAtoms];
    }

    private boolean addMasque(Masque masque) {
        int iat = 0;
        while (iat < this.conf.length) {
            int n = iat;
            this.conf[n] = this.conf[n] + masque.get(iat);
            if (this.conf[iat] < 0 || this.conf[iat] > 2) {
                return false;
            }
            ++iat;
        }
        return true;
    }

    public boolean applyMasque(int imask) {
        this.genNeutralConf();
        if (!this.addMasque(masques.get(imask - 1))) {
            return false;
        }
        this.charge = this.getCharges();
        int iatom = 0;
        while (iatom < nAtoms) {
            int jatom = iatom + 1;
            while (jatom < nAtoms) {
                if (this.charge[iatom] * this.charge[jatom] < 0 && Conf.areAdjacent(iatom, jatom)) {
                    return false;
                }
                ++jatom;
            }
            ++iatom;
        }
        return true;
    }

    private boolean areRadical(int iat, int jat) {
        return this.conf[iat] == 1 && this.conf[jat] == 1;
    }

    private void bindAtoms(int iat, int jat) {
        int n = iat;
        this.conf[n] = this.conf[n] - 1;
        int n2 = jat;
        this.conf[n2] = this.conf[n2] - 1;
        if (this.conf[iat] >= 0) {
            int cfr_ignored_0 = this.conf[jat];
        }
        this.bonds.add(new BondConf(iat, jat));
        int bondVal = (int)(Math.pow(3.0, iat) + Math.pow(3.0, jat));
        this.bondSignature.add(bondVal);
    }

    private boolean checkConf(Conf conf) {
        int iat = 0;
        while (iat < nAtoms) {
            int jat = iat + 1;
            while (jat < nAtoms) {
                if (Conf.areAdjacent(iat, jat) && conf.areRadical(iat, jat)) {
                    return false;
                }
                ++jat;
            }
            ++iat;
        }
        return true;
    }

    public int compareTo(Conf that) {
        int jsize;
        int isize = this.bondSignature.size();
        if (isize != (jsize = that.bondSignature.size())) {
            return new Integer(isize).compareTo(jsize);
        }
        Iterator<Integer> itthis = this.bondSignature.iterator();
        Iterator<Integer> itthat = that.bondSignature.iterator();
        while (itthis.hasNext()) {
            int jval;
            int ival = itthis.next();
            int icomp = new Integer(ival).compareTo(jval = itthat.next().intValue());
            if (icomp == 0) continue;
            return icomp;
        }
        int rc = Conf.compareConf(this.conf, that.conf);
        return rc;
    }

    public int countRadical() {
        int nbre = 0;
        int iat = 0;
        while (iat < nAtoms) {
            if (this.conf[iat] == 1) {
                ++nbre;
            }
            ++iat;
        }
        return nbre;
    }

    public void dressStructureLocalized(StructureLocalized struct) throws Exception {
        for (BondConf bond : this.bonds) {
            int type = 2;
            struct.changeBondType(bond.getAtom1() + 1, bond.getAtom2() + 1, type);
        }
        int iat = 0;
        while (iat < nAtoms) {
            int irad = this.conf[iat];
            struct.getHuckelAtomBySeqNum(iat + 1).do_setRadR(irad);
            ++iat;
        }
        boolean toCouple = false;
        int iAtom = -1;
        int jAtom = -1;
        int iat2 = 0;
        block2: while (iat2 < nAtoms) {
            int jat = iat2 + 1;
            while (jat < nAtoms) {
                if (Preferences.isCOUPLE_AUTOGEN() && !Conf.areAdjacent(iat2, jat) && this.areRadical(iat2, jat)) {
                    if (iAtom != -1 && jAtom != -1) break block2;
                    iAtom = iat2 + 1;
                    jAtom = jat + 1;
                    toCouple = true;
                }
                ++jat;
            }
            ++iat2;
        }
        if (toCouple) {
            if (!(struct.getAtomBySeqNum(iAtom) instanceof HuckelAtom)) {
                throw new ConfException("Atome " + iAtom + " a coupler automatiquement n'est pas un HuckelAtom");
            }
            if (!(struct.getAtomBySeqNum(jAtom) instanceof HuckelAtom)) {
                throw new ConfException("Atome " + jAtom + " a coupler automatiquement n'est pas un HuckelAtom");
            }
            struct.setCouple(new CoupleLocal((HuckelAtom)struct.getAtomBySeqNum(iAtom), (HuckelAtom)struct.getAtomBySeqNum(jAtom)));
        }
        iat2 = 0;
        while (iat2 < nAtoms) {
            int icharge = this.charge[iat2];
            struct.getHuckelAtomBySeqNum(iat2 + 1).setCharge(icharge);
            ++iat2;
        }
    }

    public boolean equals(Object o1) {
        Conf that = (Conf)o1;
        for (int bondVal : this.bondSignature) {
            if (that.bondSignature.contains(bondVal)) continue;
            return false;
        }
        return true;
    }

    public void erase() {
        if (masques != null) {
            for (Masque mask : masques) {
                mask.erase();
                Object var1_2 = null;
            }
        }
        List = null;
        masques = null;
        Zpi = null;
        topology = null;
        MaxLevel = -1;
        nAtoms = -1;
        this.conf = null;
        this.charge = null;
        this.bondSignature = null;
        this.level = -99;
        this.next = null;
        this.bonds = null;
    }

    public int generate(int nrad) {
        int nbre = 0;
        int iat = 0;
        while (iat < nAtoms) {
            int jat = iat + 1;
            while (jat < nAtoms) {
                if (mesomery != null && mesomery.isStopConsumingProccess()) break;
                if (Conf.areAdjacent(iat, jat) && this.areRadical(iat, jat)) {
                    if (mesomery != null && mesomery.isStopConsumingProccess()) break;
                    Conf newConf = new Conf(this);
                    newConf.bindAtoms(iat, jat);
                    if (Conf.isNew(newConf)) {
                        newConf.levelUP();
                        if (this.next == null) {
                            this.next = new ArrayList();
                        }
                        this.next.add(newConf);
                        int newNrad = newConf.countRadical();
                        if (newNrad > nrad) {
                            nbre += newConf.generate(nrad);
                        }
                        if (newNrad == nrad && this.checkConf(newConf)) {
                            List.add(newConf);
                            ++nbre;
                        }
                    }
                }
                ++jat;
            }
            ++iat;
        }
        return nbre;
    }

    private void genNeutralConf() {
        int iat = 0;
        while (iat < nAtoms) {
            this.conf[iat] = Zpi[iat];
            ++iat;
        }
    }

    public int[] getCharges() {
        int[] charges = new int[nAtoms];
        int iat = 0;
        while (iat < nAtoms) {
            charges[iat] = Zpi[iat] - this.conf[iat];
            ++iat;
        }
        return charges;
    }

    public ArrayList<Conf> getList(int lvl) {
        ArrayList<Conf> lst = new ArrayList<Conf>();
        if (this.next == null || this.level == lvl) {
            lst.add(this);
        } else {
            for (Conf config : this.next) {
                config.getList(lvl);
            }
        }
        return lst;
    }

    private void levelUP() {
        ++this.level;
        MaxLevel = Math.max(MaxLevel, this.level);
    }

    public void stopFlyCalculate(Mesomery mesomery) {
        mesomery.isEnabledFlyCalculate = false;
    }

    public static void main(String[] args) {
        Exemple[] exempleArray = Exemple.values();
        int n = exempleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Exemple ex = exempleArray[n2];
            long t0 = System.currentTimeMillis();
            Zpi = null;
            List = null;
            topology = null;
            int[][] topo = ex.getTopo();
            int nHuckelAtoms = topo.length;
            int[] nElecPi = ex.getnElecPi();
            int totalCharge = ex.getTotalCharge();
            System.out.println(String.valueOf(ex.toString()) + ":");
            Conf config = new Conf(topo, nHuckelAtoms, nElecPi, totalCharge);
            int imask = 1;
            while (imask <= Conf.nMasque()) {
                if (config.applyMasque(imask)) {
                    int nMaxRadical = 2;
                    if (!Preferences.isCOUPLE_AUTOGEN()) {
                        nMaxRadical = 0;
                    }
                    int nRadical = 0;
                    while (nRadical <= nMaxRadical) {
                        config.generate(nRadical);
                        ++nRadical;
                    }
                }
                ++imask;
            }
            System.out.println(String.valueOf(Conf.getList().size()) + " structures found:");
            for (Conf conf : Conf.getList()) {
                for (BondConf bc : conf.bonds) {
                    int iAt1 = bc.getAtom1();
                    int iAt2 = bc.getAtom2();
                    System.out.print(String.valueOf(iAt1) + "=" + iAt2 + " ");
                }
                int iat = 0;
                while (iat < conf.conf.length) {
                    System.out.print(conf.conf[iat]);
                    ++iat;
                }
                System.out.println();
            }
            long t1 = System.currentTimeMillis();
            System.out.println("time:" + (t1 - t0) + " ms");
            ++n2;
        }
    }

    private static final class Exemple
    extends Enum<Exemple> {
        public static final /* enum */ Exemple BUTADIENE;
        public static final /* enum */ Exemple NAPHTALENE;
        public static final /* enum */ Exemple BENZENE;
        private int[][] topo;
        private int[] nElecPi;
        private int totalCharge;
        private static final /* synthetic */ Exemple[] ENUM$VALUES;

        static {
            int[][] nArrayArray = new int[4][];
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[2] = 1;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[4];
            nArray3[1] = 1;
            nArray3[3] = 1;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[4];
            nArray4[2] = 1;
            nArrayArray[3] = nArray4;
            BUTADIENE = new Exemple(nArrayArray, new int[]{1, 1, 1, 1}, 0);
            int[][] nArrayArray2 = new int[10][];
            int[] nArray5 = new int[10];
            nArray5[1] = 1;
            nArray5[9] = 1;
            nArrayArray2[0] = nArray5;
            int[] nArray6 = new int[10];
            nArray6[0] = 1;
            nArray6[2] = 1;
            nArrayArray2[1] = nArray6;
            int[] nArray7 = new int[10];
            nArray7[1] = 1;
            nArray7[3] = 1;
            nArray7[7] = 1;
            nArrayArray2[2] = nArray7;
            int[] nArray8 = new int[10];
            nArray8[2] = 1;
            nArray8[4] = 1;
            nArrayArray2[3] = nArray8;
            int[] nArray9 = new int[10];
            nArray9[3] = 1;
            nArray9[5] = 1;
            nArrayArray2[4] = nArray9;
            int[] nArray10 = new int[10];
            nArray10[4] = 1;
            nArray10[6] = 1;
            nArrayArray2[5] = nArray10;
            int[] nArray11 = new int[10];
            nArray11[5] = 1;
            nArray11[7] = 1;
            nArrayArray2[6] = nArray11;
            int[] nArray12 = new int[10];
            nArray12[2] = 1;
            nArray12[6] = 1;
            nArray12[8] = 1;
            nArrayArray2[7] = nArray12;
            int[] nArray13 = new int[10];
            nArray13[7] = 1;
            nArray13[9] = 1;
            nArrayArray2[8] = nArray13;
            int[] nArray14 = new int[10];
            nArray14[0] = 1;
            nArray14[8] = 1;
            nArrayArray2[9] = nArray14;
            NAPHTALENE = new Exemple(nArrayArray2, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, 0);
            int[][] nArrayArray3 = new int[6][];
            int[] nArray15 = new int[6];
            nArray15[1] = 1;
            nArray15[5] = 1;
            nArrayArray3[0] = nArray15;
            int[] nArray16 = new int[6];
            nArray16[0] = 1;
            nArray16[2] = 1;
            nArrayArray3[1] = nArray16;
            int[] nArray17 = new int[6];
            nArray17[1] = 1;
            nArray17[3] = 1;
            nArrayArray3[2] = nArray17;
            int[] nArray18 = new int[6];
            nArray18[2] = 1;
            nArray18[4] = 1;
            nArrayArray3[3] = nArray18;
            int[] nArray19 = new int[6];
            nArray19[3] = 1;
            nArray19[5] = 1;
            nArrayArray3[4] = nArray19;
            int[] nArray20 = new int[6];
            nArray20[0] = 1;
            nArray20[4] = 1;
            nArrayArray3[5] = nArray20;
            BENZENE = new Exemple(nArrayArray3, new int[]{1, 1, 1, 1, 1, 1}, 0);
            ENUM$VALUES = new Exemple[]{BUTADIENE, NAPHTALENE, BENZENE};
        }

        public int[][] getTopo() {
            return this.topo;
        }

        public int[] getnElecPi() {
            return this.nElecPi;
        }

        public int getTotalCharge() {
            return this.totalCharge;
        }

        private Exemple(int[][] topo, int[] nElecPi, int totalCharge) {
            this.topo = topo;
            this.nElecPi = nElecPi;
            this.totalCharge = totalCharge;
        }

        public static Exemple[] values() {
            Exemple[] exempleArray = ENUM$VALUES;
            int n = exempleArray.length;
            Exemple[] exempleArray2 = new Exemple[n];
            System.arraycopy(ENUM$VALUES, 0, exempleArray2, 0, n);
            return exempleArray2;
        }

        public static Exemple valueOf(String string) {
            return Enum.valueOf(Exemple.class, string);
        }
    }
}

