/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.geometry;

import java.util.ArrayList;
import java.util.List;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.exception.HuckelAtomException;
import org.ctom.hulis.util.geometry.InitialOrientation;
import org.ctom.hulis.util.geometry.VirtualBond;
import org.ctom.hulis.util.geometry.VirtualMethyl;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.Rotation;
import org.ctom.util.maths.VecteurCTOM;

public class Geometry {
    public static final int SCALE = 50;
    public static final double TRESHOLD_DIST = 0.2;
    ArrayList<VirtualMethyl> lstVirtualMethyls = new ArrayList();
    private ArrayList<Atom> geom = new ArrayList();
    private List<Bond> lstBonds3D;
    int nombre = 0;
    private InitialOrientation initialOrientation;
    private int nbAtomSav;

    public Geometry() {
        this.initialOrientation = new InitialOrientation();
        this.nbAtomSav = 0;
    }

    public Point3D getCenter() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double nbAtomes = this.countAtoms();
        HuckelIO.PrintIf(nbAtomes);
        if (nbAtomes == 0.0) {
            return new Point3D(0.0, 0.0, 0.0);
        }
        for (Atom a : this.geom) {
            x += a.getX();
            y += a.getY();
            z += a.getZ();
        }
        return new Point3D(x / nbAtomes, y / nbAtomes, z / nbAtomes);
    }

    public PeriodicTable.Entry atomToEntry(Atom atom) {
        return PeriodicTable.getElementToEntry(atom.getElement(), atom.getConnect().size());
    }

    public Geometry(Geometry that) {
        this.nombre = that.nombre;
        this.geom = (ArrayList)that.geom.clone();
        this.lstVirtualMethyls = (ArrayList)that.lstVirtualMethyls.clone();
        this.initialOrientation = (InitialOrientation)that.initialOrientation.clone();
        this.nbAtomSav = that.nbAtomSav;
    }

    public Geometry(Molecule molecule) throws GeometryException {
        this.nbAtomSav = 0;
        this.synchronize(molecule);
        this.initialOrientation = new InitialOrientation();
    }

    public void add(Atom atom) {
        ++this.nombre;
        atom.setSuperSymbol(this.nombre);
        atom.setXAndXGeom3D(atom.getX() * 50.0);
        atom.setYAndYGeom3D(atom.getY() * 50.0);
        atom.setZAndZGeom3D(atom.getZ() * 50.0);
        this.geom.add(atom);
        ++this.nbAtomSav;
    }

    public int countAtoms() {
        return this.geom.size();
    }

    public void clearConnectivity() {
        for (Atom atom : this.getAtoms()) {
            atom.getConnect().clear();
        }
    }

    public void generateConnectivity() {
        if (!this.isConnectivityEmpty()) {
            return;
        }
        for (Atom atom1 : this.getGeom3D()) {
            for (Atom atom2 : this.getGeom3D()) {
                double dist = atom1.getDist3D(atom2, this.getscale());
                if (!(dist <= atom1.getCovalentRadius() + atom2.getCovalentRadius() + 0.2) || atom1.getSuperSymbol() == atom2.getSuperSymbol()) continue;
                HuckelIO.PrintIf("!! create BOND : " + atom1.getSuperSymbol() + " - " + atom2.getSuperSymbol() + "\n");
                atom1.addConnect(atom2.getSuperSymbol());
            }
        }
    }

    public void forceConnectivyFromBonds() {
        for (Atom a : this.geom) {
            a.clearConnect();
        }
        for (Bond b : this.lstBonds3D) {
            b.getAtom1().addConnect(b.getAtom2().getSuperSymbol());
        }
    }

    public ArrayList<Atom> getAtoms() {
        return this.getGeom3D();
    }

    public ArrayList<Atom> getGeom2D() {
        return this.getGeom();
    }

    @Deprecated
    public ArrayList<Atom> getGeom() {
        ArrayList<Atom> geom2D = new ArrayList<Atom>();
        for (Atom atom : this.geom) {
            if (atom.getElement() == null) continue;
            geom2D.add(atom);
        }
        this.replaceCH3ByME(geom2D);
        return geom2D;
    }

    public ArrayList<Atom> getGeom3D() {
        return this.geom;
    }

    public int getscale() {
        return 50;
    }

    private boolean isConnectivityEmpty() {
        for (Atom atom : this.getAtoms()) {
            if (atom.getConnect().size() == 0) continue;
            return false;
        }
        return true;
    }

    public void print() {
        for (Atom atom : this.geom) {
            atom.print();
        }
        HuckelIO.PrintIfln();
    }

    public void saveInitialOrientation(InitialOrientation initialOrientation) {
        this.initialOrientation = initialOrientation;
    }

    public InitialOrientation getInitialOrientation() {
        return this.initialOrientation;
    }

    public void flatGeom() {
        Point3D xyzOrign;
        VecteurCTOM n;
        double angle;
        ArrayList<Atom> tripletHuckelAtom;
        ArrayList lstTripletAtom = new ArrayList();
        int nb = this.getAtoms().size();
        int i2 = 0;
        while (i2 < nb - 2) {
            Atom atom1 = this.getAtoms().get(i2);
            int j = i2 + 1;
            while (j < nb - 1) {
                Atom atom2 = this.getAtoms().get(j);
                int k = j + 1;
                while (k < nb) {
                    Atom atom3 = this.getAtoms().get(k);
                    tripletHuckelAtom = new ArrayList<Atom>();
                    tripletHuckelAtom.add(atom1);
                    tripletHuckelAtom.add(atom2);
                    tripletHuckelAtom.add(atom3);
                    lstTripletAtom.add(tripletHuckelAtom);
                    HuckelIO.PrintIfln(atom1 + " " + atom2 + " " + atom3 + atom3.getLocation());
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<VecteurCTOM> lstPlan = new ArrayList<VecteurCTOM>();
        VecteurCTOM memo_n = null;
        VecteurCTOM vZ = VecteurCTOM.V_Z_AXIS;
        nb = lstTripletAtom.size();
        int i3 = 0;
        while (i3 < nb) {
            VecteurCTOM ac;
            tripletHuckelAtom = (ArrayList<Atom>)lstTripletAtom.get(i3);
            Atom a = (Atom)tripletHuckelAtom.get(0);
            Atom b = (Atom)tripletHuckelAtom.get(1);
            Atom c = (Atom)tripletHuckelAtom.get(2);
            VecteurCTOM ab = new VecteurCTOM(a.getLocation(), b.getLocation());
            angle = ab.getAngle(ac = new VecteurCTOM(a.getLocation(), c.getLocation()));
            if (angle != 0.0) {
                n = ab.getCrossProduct(ac);
                HuckelIO.PrintIf("i =" + i3);
                if (memo_n == null && n.getDotProduct(vZ) == 0.0) {
                    memo_n = n.normalize();
                    HuckelIO.PrintIf("a " + i3);
                } else if (memo_n == null) {
                    n.timesEquals(n.getDotProduct(vZ));
                    n.normalizeEquals();
                    memo_n = (VecteurCTOM)n.clone();
                    HuckelIO.PrintIf("b " + i3);
                } else {
                    n.timesEquals(n.getDotProduct(memo_n));
                    n.normalizeEquals();
                    HuckelIO.PrintIf("c " + i3);
                }
                HuckelIO.PrintIfln("abc " + a + b + c + "   n=" + n);
                lstPlan.add(n);
            }
            ++i3;
        }
        double abar = 0.0;
        double bbar = 0.0;
        double cbar = 0.0;
        nb = lstPlan.size();
        int i4 = 0;
        while (i4 < nb) {
            n = (VecteurCTOM)lstPlan.get(i4);
            abar += n.getX();
            bbar += n.getY();
            cbar += n.getZ();
            ++i4;
        }
        VecteurCTOM nbar = new VecteurCTOM(abar /= (double)lstPlan.size(), bbar /= (double)lstPlan.size(), cbar /= (double)lstPlan.size());
        nbar.normalizeEquals();
        HuckelIO.PrintIfln("n moy= " + nbar);
        angle = Math.acos(nbar.getDotProduct(vZ));
        VecteurCTOM v = nbar.getCrossProduct(vZ);
        v.normalizeEquals();
        HuckelIO.PrintIfln("angle = " + angle);
        HuckelIO.PrintIfln("cos = " + Math.cos(angle));
        HuckelIO.PrintIfln("sin = " + Math.sin(angle));
        HuckelIO.PrintIfln("v = " + v);
        Rotation mRotate = Rotation.getRotation3D(v, angle);
        HuckelIO.PrintIfln("avant translation");
        Point3D center = this.getCenter();
        HuckelIO.PrintIfln("center " + center.getX() / 50.0 + " " + center.getY() / 50.0 + " " + center.getZ() / 50.0);
        for (Atom atom : this.getAtoms()) {
            HuckelIO.PrintIfln(atom + " " + atom.getX() / 50.0 + " " + atom.getY() / 50.0 + " " + atom.getZ() / 50.0);
        }
        Point3D origine = new Point3D(0.0, 0.0, 0.0);
        for (Atom atom : this.getAtoms()) {
            xyzOrign = (Point3D)atom.getLocationGeom3D().clone();
            atom.translate(new VecteurCTOM(origine, center));
            atom.setLocationGeom3D(xyzOrign);
        }
        HuckelIO.PrintIfln("apres translation avant rotation");
        for (Atom atom : this.getAtoms()) {
            HuckelIO.PrintIfln(atom + " " + atom.getX() / 50.0 + " " + atom.getY() / 50.0 + " " + atom.getZ() / 50.0);
        }
        if (!Double.isNaN(angle) && !v.isInfinite() && angle % Math.PI != 0.0) {
            for (Atom atom : this.getAtoms()) {
                xyzOrign = (Point3D)atom.getLocationGeom3D().clone();
                atom.rotate(mRotate);
                atom.setLocationGeom3D(xyzOrign);
            }
        } else {
            HuckelIO.PrintIfln("Rotation annulee");
        }
        HuckelIO.PrintIfln("apres rotation");
        for (Atom atom : this.getAtoms()) {
            HuckelIO.PrintIfln(atom + " " + atom.getX() / 50.0 + " " + atom.getY() / 50.0 + " " + atom.getZ() / 50.0);
        }
        InitialOrientation savedInitialOrientation = new InitialOrientation(v, angle, this.getCenter());
        this.saveInitialOrientation(savedInitialOrientation);
    }

    public Atom getAtomBySuperSymbol(int i2) {
        for (Atom a : this.getAtoms()) {
            if (a.getSuperSymbol() != i2) continue;
            return a;
        }
        return null;
    }

    protected void replaceCH3ByME(List<Atom> lstAtoms2D) {
        this.lstVirtualMethyls = new ArrayList();
        ArrayList<Atom> lstHToRemove = new ArrayList<Atom>();
        int index = 0;
        while (index < lstAtoms2D.size()) {
            Atom a = lstAtoms2D.get(index);
            if (a.getElement() == PeriodicTable.Element.C) {
                HuckelIO.PrintIfln("C trouve");
                ArrayList<Integer> lstConnect = a.getConnect();
                ArrayList<Atom> lstAtomConnect = new ArrayList<Atom>();
                ArrayList<Atom> lstH = new ArrayList<Atom>();
                Atom autreAtomeLieQueH = null;
                int i2 = 0;
                while (i2 < lstConnect.size()) {
                    Atom atomLie = this.getAtomBySuperSymbol((Integer)lstConnect.get(i2));
                    if (atomLie != null && atomLie.getElement() == PeriodicTable.Element.H) {
                        lstH.add(atomLie);
                    } else if (atomLie != null) {
                        autreAtomeLieQueH = atomLie;
                    }
                    lstAtomConnect.add(atomLie);
                    ++i2;
                }
                if (lstAtomConnect.size() == 4 && lstH.size() == 3) {
                    HuckelIO.PrintIfln("methyl detected");
                    lstHToRemove.add((Atom)lstH.get(0));
                    lstHToRemove.add((Atom)lstH.get(1));
                    lstHToRemove.add((Atom)lstH.get(2));
                    Atom me = PeriodicTable.getNewAtom(PeriodicTable.Entry.Me);
                    try {
                        if (a instanceof HuckelAtom) {
                            ((HuckelAtom)me).setRadR(((HuckelAtom)a).countRadR());
                        }
                    }
                    catch (HuckelAtomException e1) {
                        e1.printStackTrace();
                    }
                    me.setLocation((Point3D)a.getLocation().clone());
                    me.setLocationGeom3D(a.getLocationGeom3D());
                    me.setSuperSymbol(a.getSuperSymbol());
                    me.addConnect(autreAtomeLieQueH.getSuperSymbol());
                    lstAtoms2D.set(index, me);
                    try {
                        this.lstVirtualMethyls.add(new VirtualMethyl(a, (Atom)lstH.get(0), (Atom)lstH.get(1), (Atom)lstH.get(2), me));
                    }
                    catch (GeometryException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++index;
        }
        lstAtoms2D.removeAll(lstHToRemove);
    }

    public Bond getBond(Atom a1, Atom a2) {
        if (a1 == null || a1 == null) {
            return null;
        }
        for (Bond l : this.lstBonds3D) {
            if (!l.contains(a1, a2)) continue;
            return l;
        }
        return null;
    }

    private List<Bond> getBonds3D(Molecule molecule) {
        List<Bond> lstBonds2D = molecule.getBonds();
        ArrayList<Bond> lstBonds3D = new ArrayList<Bond>();
        for (Bond b : lstBonds2D) {
            Atom me = b.getAtom(PeriodicTable.Element.Me);
            if (me != null) {
                try {
                    VirtualMethyl virtualMethyl = this.getVirtualMethyl(me);
                    Atom neighbour = b.getAtomLinkedWith(me);
                    Atom c = virtualMethyl.getC();
                    int bondType = 1;
                    if (b instanceof HuckelBond) {
                        bondType = ((HuckelBond)b).getBondType();
                    }
                    lstBonds3D.add(new VirtualBond(neighbour, c, me, bondType));
                    lstBonds3D.addAll(virtualMethyl.getBonds());
                }
                catch (BondException e) {
                    e.printStackTrace();
                }
                continue;
            }
            lstBonds3D.add(b);
        }
        return lstBonds3D;
    }

    public List<Bond> getBonds3D() {
        return this.lstBonds3D;
    }

    private VirtualMethyl getVirtualMethyl(Atom me) {
        try {
            if (me.getElement() != PeriodicTable.Element.Me) {
                throw new GeometryException("getSubsitutedMethyl : this atom is not a methyl ME");
            }
            if (me.getSuperSymbol() == 0) {
                throw new GeometryException("getSubsitutedMethyl : the supersymbol of ME in parameter == 0 : cannot get substituted methyl");
            }
        }
        catch (GeometryException e) {
            e.printStackTrace();
            return null;
        }
        for (VirtualMethyl virtualMethyl : this.getMethyls()) {
            if (!virtualMethyl.isSubsituteOf(me)) continue;
            return virtualMethyl;
        }
        return null;
    }

    private List<VirtualMethyl> getMethyls() {
        return this.lstVirtualMethyls;
    }

    protected VirtualMethyl replaceMEByCH3(Atom me) {
        VirtualMethyl virtualMethyl = this.getVirtualMethyl(me);
        if (virtualMethyl != null) {
            HuckelIO.PrintIfln("replaceMEByCH3: methyl restaure");
            virtualMethyl.autoUpdate();
            return virtualMethyl;
        }
        if (me.getElement() == PeriodicTable.Element.Me) {
            HuckelIO.PrintIfln("replaceMEByCH3 : nouveau methyl");
            ArrayList<Atom> methylGroup = new ArrayList<Atom>(4);
            Atom c = PeriodicTable.getNewAtom(PeriodicTable.Entry.C);
            c.setSuperSymbol(me.getSuperSymbol());
            methylGroup.add(c);
            int i2 = 0;
            while (i2 < 3) {
                Atom h = PeriodicTable.getNewAtom(PeriodicTable.Entry.H);
                methylGroup.add(h);
                ++i2;
            }
            try {
                virtualMethyl = new VirtualMethyl(methylGroup, me);
                virtualMethyl.autoUpdate();
                return virtualMethyl;
            }
            catch (GeometryException e) {
                e.printStackTrace();
                return null;
            }
        }
        HuckelIO.PrintIfln("Probleme replaceMEByCH3 : Le  methyl n'a pas pu etre restaure et il ne s'agit pas non plus d'un nouveau methyl : element = " + (Object)((Object)me.getElement()) + " symbol =" + me.getSuperSymbol());
        return null;
    }

    public void synchronize(Molecule molecule) throws GeometryException {
        for (VirtualMethyl virtualMethyl : this.lstVirtualMethyls) {
            Atom me = molecule.getAtomBySuperSymbol(virtualMethyl.getSubstituteME().getSuperSymbol());
            if (me == null) continue;
            virtualMethyl.setSubsituteOf(me);
        }
        boolean isNewAtoms = false;
        if (molecule.countAtoms() != this.getAtoms().size() - this.lstVirtualMethyls.size() * 3) {
            isNewAtoms = true;
        } else {
            for (Atom a : molecule.getAtoms()) {
                if (a.getSuperSymbol() != 0) continue;
                isNewAtoms = true;
            }
        }
        if (!isNewAtoms) {
            HuckelIO.PrintIfln("there is not new atoms");
            for (Atom a : molecule.getAtoms()) {
                if (a.getElement() == PeriodicTable.Element.Me) continue;
                int i2 = 0;
                while (i2 < this.getAtoms().size()) {
                    if (this.getAtoms().get(i2).getSuperSymbol() == a.getSuperSymbol()) {
                        this.geom.set(i2, a);
                    }
                    ++i2;
                }
            }
            for (VirtualMethyl virtualMethyl : this.lstVirtualMethyls) {
                virtualMethyl.autoUpdate();
            }
            this.lstBonds3D = this.getBonds3D(molecule);
            this.forceConnectivyFromBonds();
            return;
        }
        HuckelIO.PrintIfln("there is new atoms : recreate geom");
        this.geom.clear();
        this.nombre = 0;
        this.clearConnectivity();
        ArrayList<VirtualMethyl> lstVirtualMethyls = new ArrayList<VirtualMethyl>();
        for (Atom a : molecule.getAtoms()) {
            if (a == null) {
                HuckelIO.error(this.getClass().getName(), "set", "Atom is null in Geometry.set(molecule)");
                throw new GeometryException("error geometry.synchronize(molecule) : atom is null");
            }
            if (a.getElement() != PeriodicTable.Element.Me) {
                ++this.nombre;
                a.setSuperSymbol(this.nombre);
                this.geom.add(a);
                continue;
            }
            VirtualMethyl virtualMethyl = this.replaceMEByCH3(a);
            if (virtualMethyl != null) {
                ++this.nombre;
                a.setSuperSymbol(this.nombre);
                virtualMethyl.getC().setSuperSymbol(this.nombre);
                ++this.nombre;
                virtualMethyl.getH1().setSuperSymbol(this.nombre);
                ++this.nombre;
                virtualMethyl.getH2().setSuperSymbol(this.nombre);
                ++this.nombre;
                virtualMethyl.getH3().setSuperSymbol(this.nombre);
                this.geom.addAll(virtualMethyl.getCH3());
                lstVirtualMethyls.add(virtualMethyl);
                continue;
            }
            throw new GeometryException("geometry.synchronize(molecule) : replaceMEByCH3 has returned null !");
        }
        this.lstVirtualMethyls = lstVirtualMethyls;
        for (Bond b : molecule.getBonds()) {
            b.getAtom1().addConnect(b.getAtom2().getSuperSymbol());
            b.getAtom2().addConnect(b.getAtom1().getSuperSymbol());
        }
        this.lstBonds3D = this.getBonds3D(molecule);
        this.nbAtomSav = molecule.countAtoms();
    }
}

