/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.geometry;

import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.VecteurCTOM;

public class InitialOrientation {
    VecteurCTOM axis;
    double angle;
    Point3D origin;

    public InitialOrientation(VecteurCTOM axis, double angle, Point3D origin) {
        this.axis = axis;
        this.angle = angle;
        this.origin = origin;
    }

    public InitialOrientation(InitialOrientation initialOrientation) {
        this.axis = (VecteurCTOM)initialOrientation.axis.clone();
        this.angle = initialOrientation.angle;
        this.origin = (Point3D)initialOrientation.origin.clone();
    }

    public Object clone() {
        return new InitialOrientation(this);
    }

    public InitialOrientation() {
        this.axis = VecteurCTOM.V_Z_AXIS;
        this.angle = 0.0;
        this.origin = new Point3D(0.0, 0.0, 0.0);
    }

    public VecteurCTOM getAxis() {
        return this.axis;
    }

    public double getAngle() {
        return this.angle;
    }

    public Point3D getOrigin() {
        return this.origin;
    }

    public String toString() {
        return "axis = " + this.axis + " ; angle = " + this.angle + " ; origin = " + this.origin;
    }
}

