/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.geometry;

import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;

public class VirtualBond
extends Bond {
    int bondType;
    private Atom substitutedME;

    public VirtualBond(Atom neighbour, Atom c, Atom substitutedME, int bondType) throws BondException, HuckelBondException {
        super(neighbour, c);
        if (c.getElement() != PeriodicTable.Element.C) {
            throw new BondException("atom type C expected in parameter");
        }
        if (substitutedME.getElement() != PeriodicTable.Element.Me) {
            throw new BondException("substitutedME is not a ME");
        }
        if (substitutedME.getSuperSymbol() != c.getSuperSymbol()) {
            throw new BondException("substitutedME and C have not the same super symbol");
        }
        this.substitutedME = substitutedME;
        this.bondType = bondType;
    }

    public int getBondType() {
        return this.bondType;
    }

    public Atom getSubistutuedME() {
        return this.substitutedME;
    }

    @Override
    protected void checkCoherence(Atom atom1, Atom atom2) throws BondException {
        if (atom1 == null || atom2 == null) {
            throw new BondException("atom must be intialized");
        }
        if (atom1 == atom2) {
            throw new BondException("atom must be different");
        }
        if (atom1 == null || atom2 == null) {
            throw new BondException("atom must be in a molecule");
        }
    }

    public void setBondType(int bondType) {
        this.bondType = bondType;
    }
}

