/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.geometry.optimizer;

import Jama.Matrix;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.util.maths.minimizer.MultiVariableFunction;

public class Geom2DOptimizableFunction
implements MultiVariableFunction {
    private int nAt;
    private int[][] topo;
    private boolean verbose = false;
    private Molecule molecule;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Geom2DOptimizableFunction(Molecule molecule) {
        this.nAt = molecule.getHuckelAtoms().size();
        this.topo = molecule.getTopology();
        this.molecule = molecule;
    }

    @Override
    public int getDimension() {
        return this.nAt * 2;
    }

    @Override
    public double getValue(Matrix v) {
        double E = 0.0;
        double ALPHA0 = 2.0943951023931953;
        ArrayList<Double> bondValues = new ArrayList<Double>();
        ArrayList<Double> angleValues = new ArrayList<Double>();
        E += this.getBondEnergy(v, E, bondValues);
        E += this.getAngleEnergy(v, E, ALPHA0, angleValues);
        if (this.verbose) {
            for (double d : bondValues) {
                System.out.print("  " + d);
            }
            for (double a : angleValues) {
                System.out.print("  " + a);
            }
            System.out.println();
        }
        return E;
    }

    private double getAngleEnergy(Matrix v, double E, double ALPHA0, ArrayList<Double> angles) {
        int iat = 0;
        while (iat < this.nAt) {
            double xi = v.get(iat * 2, 0);
            double yi = v.get(iat * 2 + 1, 0);
            int jat = 0;
            while (jat < this.nAt) {
                if (iat != jat && this.topo[iat][jat] != 0) {
                    double xj = v.get(jat * 2, 0);
                    double yj = v.get(jat * 2 + 1, 0);
                    double dij = Math.sqrt(Math.pow(xj - xi, 2.0) + Math.pow(yj - yi, 2.0));
                    int kat = jat + 1;
                    while (kat < this.nAt) {
                        if (kat != jat && this.topo[iat][kat] != 0) {
                            double xk = v.get(kat * 2, 0);
                            double yk = v.get(kat * 2 + 1, 0);
                            double dik = Math.sqrt(Math.pow(xk - xi, 2.0) + Math.pow(yk - yi, 2.0));
                            double djk = Math.sqrt(Math.pow(xk - xj, 2.0) + Math.pow(yk - yj, 2.0));
                            double tmp = dij * dij + dik * dik - djk * djk;
                            double alpha = Math.acos(tmp /= 2.0 * dij * dik);
                            angles.add(alpha);
                            E += Math.pow(alpha / ALPHA0 - 1.0, 2.0);
                        }
                        ++kat;
                    }
                }
                ++jat;
            }
            ++iat;
        }
        return E;
    }

    private double getBondEnergy(Matrix v, double E, ArrayList<Double> bonds) {
        int iat = 0;
        while (iat < this.nAt) {
            double xi = v.get(iat * 2, 0);
            double yi = v.get(iat * 2 + 1, 0);
            int jat = iat + 1;
            while (jat < this.nAt) {
                if (this.topo[iat][jat] != 0) {
                    double xj = v.get(jat * 2, 0);
                    double yj = v.get(jat * 2 + 1, 0);
                    double dij = Math.sqrt(Math.pow(xj - xi, 2.0) + Math.pow(yj - yi, 2.0));
                    bonds.add(dij);
                    Atom a1 = this.molecule.getAtomByIndex(iat + 1);
                    Atom a2 = this.molecule.getAtomByIndex(jat + 1);
                    double DOPT = this.molecule.getBond(a1, a2) != null && a1 instanceof HuckelAtom && a2 instanceof HuckelAtom ? this.molecule.getBond(a1, a2).getOptimalValue() : a1.getCovalentRadius() + a2.getCovalentRadius();
                    E += Math.pow(dij / (DOPT *= 50.0) - 1.0, 2.0);
                }
                ++jat;
            }
            ++iat;
        }
        return E;
    }
}

