/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.geometry.optimizer;

import Jama.Matrix;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.listeners.IMoleculeValueListener;
import org.ctom.hulis.util.geometry.optimizer.Geom2DOptimizableFunction;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.minimizer.PowellMinimizer;
import org.ctom.util.maths.minimizer.PowellMinimizerListener;

public class Geom2DOptimizer
implements IMoleculeValueListener,
PowellMinimizerListener {
    private Molecule molecule;
    private boolean opt = true;
    private boolean verbose = false;
    private ArrayList<HuckelAtom> listAtoms;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Geom2DOptimizer(Molecule molecule) {
        this.molecule = molecule;
        molecule.addListener(this);
    }

    private void updateAndOptimize() {
        if (!this.opt) {
            return;
        }
        this.listAtoms = null;
        this.listAtoms = (ArrayList)this.molecule.getHuckelAtoms();
        Point3D G = this.computeCenterofMass(this.listAtoms);
        if (G.getZ() != 0.0) {
            HuckelIO.error(this.getClass().toString(), "updateAndOptimize", "Non planar molecule : cannot optimize geometry");
        }
        Matrix geom = new Matrix(2 * this.listAtoms.size(), 1);
        int iat = 0;
        while (iat < this.listAtoms.size()) {
            Atom a = this.listAtoms.get(iat);
            geom.set(iat * 2, 0, a.getX());
            geom.set(iat * 2 + 1, 0, a.getY());
            ++iat;
        }
        Geom2DOptimizableFunction func = new Geom2DOptimizableFunction(this.molecule);
        PowellMinimizer opt = new PowellMinimizer(func);
        opt.setOptimizationParameters(geom, 100, 1.0E-4, 1.0E-4);
        opt.addListener(this);
        Matrix optgeom = opt.minimize();
        if (this.verbose) {
            HuckelIO.PrintIf(String.valueOf(opt.getStopReason().toString()) + " : " + opt.getStopValue());
        }
        this.updateCoords(optgeom);
    }

    private void updateCoords(Matrix optgeom) {
        int iat = 0;
        while (iat < this.listAtoms.size()) {
            Atom a = this.listAtoms.get(iat);
            a.setLocationNotNotify(new Point3D(optgeom.get(iat * 2, 0), optgeom.get(iat * 2 + 1, 0), 0.0));
            this.molecule.correctHBonds();
            ++iat;
        }
    }

    private Point3D computeCenterofMass(ArrayList<HuckelAtom> listAtoms) {
        Point3D G = new Point3D(0.0, 0.0, 0.0);
        for (Atom atom : listAtoms) {
            G.plusEquals(atom.getLocation());
        }
        return G;
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        this.updateAndOptimize();
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        this.updateAndOptimize();
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        this.updateAndOptimize();
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        this.updateAndOptimize();
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        this.updateAndOptimize();
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
    }

    public void setOptimize(boolean b) {
        this.opt = b;
    }

    @Override
    public void intermediateValues(Matrix matrix) {
        this.updateCoords(matrix);
    }
}

