/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.io;

import Jama.Matrix;
import org.ctom.hulis.huckel.IDebuggable;
import org.ctom.hulis.util.io.MyLogger;

public class HuckelIO {
    private static StringBuffer buffer = null;
    private static MyLogger logger = new MyLogger();
    private static final boolean verbose = false;

    public static MyLogger getLooger() {
        return logger;
    }

    public static void PrintMatrix(Matrix mat) {
        int nlig = mat.getRowDimension();
        int ncol = mat.getColumnDimension();
        double[][] tab = mat.getArrayCopy();
        HuckelIO.PrintIf(String.format("\n", new Object[0]));
        int i2 = 0;
        while (i2 < nlig) {
            int j = 0;
            while (j < ncol) {
                HuckelIO.PrintIf(String.format("%8.4f", tab[i2][j]));
                ++j;
            }
            HuckelIO.PrintIf(String.format("\n", new Object[0]));
            ++i2;
        }
        HuckelIO.PrintIf(String.format("\n", new Object[0]));
    }

    public static void PrintMatrix(Matrix mat, String str) {
        HuckelIO.begin(str);
        HuckelIO.PrintMatrix(mat);
        HuckelIO.end(str);
    }

    public static void PrintVector(double[] vector) {
        double[] tab = vector;
        HuckelIO.PrintIf(String.format("\n", new Object[0]));
        int i2 = 0;
        while (i2 < tab.length) {
            HuckelIO.PrintIf(String.format("%8.4f", tab[i2]));
            HuckelIO.PrintIf(String.format("\n", new Object[0]));
            ++i2;
        }
        HuckelIO.PrintIfln(String.format("\n", new Object[0]));
    }

    public static void PrintVector(double[] real, double[] img) {
        double[] tabR = real;
        double[] tabI = img;
        HuckelIO.PrintIf(String.format("\n", new Object[0]));
        int i2 = 0;
        while (i2 < tabR.length) {
            HuckelIO.PrintIf(String.format("%8.4f + i%8.4f", tabR[i2], tabI[i2]));
            HuckelIO.PrintIf(String.format("\n", new Object[0]));
            ++i2;
        }
        HuckelIO.PrintIfln(String.format("\n", new Object[0]));
    }

    public static void PrintVector(double[] real, double[] img, String str) {
        HuckelIO.begin(str);
        HuckelIO.PrintVector(real, img);
        HuckelIO.end(str);
    }

    public static void PrintVector(double[] vector, String str) {
        HuckelIO.begin(str);
        HuckelIO.PrintVector(vector);
        HuckelIO.end(str);
    }

    public static void begin(String str) {
        HuckelIO.PrintIfln("***BEGIN " + str);
    }

    public static void debug(IDebuggable debuggable) {
        debuggable.debug();
    }

    public static void end(String str) {
        HuckelIO.PrintIfln("***  END " + str);
    }

    public static void error(String sourceClass, String sourceMethod, String msg) {
        logger.logp("SEVERE", sourceClass, sourceMethod, msg);
    }

    public static void error(String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        logger.logp("SEVERE", sourceClass, sourceMethod, msg, thrown);
    }

    public static boolean isverbose() {
        return false;
    }

    public static void log(String sourceClass, String sourceMethod, String msg) {
        logger.logp("INFO", sourceClass, sourceMethod, msg);
    }

    public static void log(String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        logger.logp("INFO", sourceClass, sourceMethod, msg, thrown);
    }

    public static void PrintIf(Object o) {
        if (o instanceof Exception) {
            ((Exception)o).printStackTrace();
        } else if (o instanceof IDebuggable) {
            ((IDebuggable)o).debug();
        } else {
            HuckelIO.PrintIf(o.toString());
        }
    }

    public static void PrintIf(String ligne) {
    }

    public static void PrintIfln(String ligne) {
        HuckelIO.PrintIf(String.valueOf(ligne) + "\n");
    }

    public static void setBuffer(StringBuffer b) {
        buffer = b;
    }

    public static void unsetBuffer() {
        buffer = null;
    }

    public static void warning(String sourceClass, String sourceMethod, String msg) {
        logger.logp("WARNING", sourceClass, sourceMethod, msg);
    }

    public static void warning(String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        logger.logp("WARNING", sourceClass, sourceMethod, msg, thrown);
    }

    public static void PrintIfln() {
        HuckelIO.PrintIfln("");
    }
}

