/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.math;

public class Complex {
    public static DefaultComplexFormater DEFAULT_COMPLEX_FORMATER = new DefaultComplexFormater();
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    private double real;
    private double imag;
    private ComplexFormater complexFormater;

    public static void setDefaultComplexFormater(DefaultComplexFormater defaultComplexFormater) {
        DEFAULT_COMPLEX_FORMATER = defaultComplexFormater;
    }

    public static String format(Complex complex, ComplexFormater complexFormater) {
        ComplexFormater tmpComplexFormater = complexFormater == null ? DEFAULT_COMPLEX_FORMATER : complexFormater;
        String formatedComplex = String.valueOf(tmpComplexFormater.formatNumber(complex.real)) + "+" + tmpComplexFormater.formatNumber(complex.imag) + " i";
        tmpComplexFormater = null;
        return formatedComplex;
    }

    public Complex(double real, double img) {
        this.real = real;
        this.imag = img;
        this.complexFormater = null;
    }

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(Complex z) {
        this.real = z.real;
        this.imag = z.imag;
        this.complexFormater = z.complexFormater;
    }

    public void setComplexFormater(ComplexFormater complexFormater) {
        this.complexFormater = complexFormater;
    }

    public void conjugate() {
        this.imag = -this.imag;
    }

    public double getNorm() {
        return Math.sqrt(this.getNorm2());
    }

    public double getNorm2() {
        return this.real * this.real + this.imag * this.imag;
    }

    public double getReal() {
        return this.real;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public double getImag() {
        return this.imag;
    }

    public void setImg(double img) {
        this.imag = img;
    }

    public void add(Complex z) {
        this.real += z.real;
        this.imag += z.imag;
    }

    public void add(double a) {
        this.real += a;
    }

    public void sub(Complex z) {
        this.real -= z.real;
        this.imag -= z.imag;
    }

    public void sub(double a) {
        this.real -= a;
    }

    public void prod(double a) {
        this.real *= a;
        this.imag *= a;
    }

    public void prod(Complex z) {
        double r = this.real * z.real - this.imag * z.imag;
        double i2 = this.real * z.imag + this.imag * z.real;
        this.real = r;
        this.imag = i2;
    }

    public Complex inverse() {
        Complex z = new Complex(this.real, -this.imag);
        z.prod(1.0 / this.getNorm2());
        return z;
    }

    public void div(Complex z) {
        this.prod(z.inverse());
    }

    public void sqrt() {
        if (this.imag == 0.0) {
            if (this.real >= 0.0) {
                this.real = Math.sqrt(this.real);
                return;
            }
            this.imag = Math.sqrt(-this.real);
            this.real = 0.0;
            return;
        }
        int sign = this.imag < 0.0 ? -1 : 1;
        double a = this.real;
        double r = this.getNorm();
        this.real = Math.sqrt(0.5 * (r + a));
        this.imag = (double)sign * Math.sqrt(0.5 * (r - a));
    }

    public void aXpb(Complex a, Complex b) {
        this.prod(a);
        this.add(b);
    }

    public void aXmb(Complex a, Complex b) {
        this.prod(a);
        this.sub(b);
    }

    public static double dist(Complex a, Complex b) {
        Complex z = new Complex(a);
        z.prod(-1.0);
        z.add(b);
        return z.getNorm();
    }

    public String toString() {
        return Complex.format(this, this.complexFormater);
    }

    public boolean isReal() {
        return this.imag == 0.0;
    }

    public static interface ComplexFormater {
        public String formatNumber(double var1);
    }

    public static class DefaultComplexFormater
    implements ComplexFormater {
        @Override
        public String formatNumber(double number) {
            return Double.toString(number);
        }
    }
}

