/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.util.math.test;

import org.ctom.hulis.util.math.Complex;
import org.junit.Assert;
import org.junit.Test;

public class ComplexTest {
    private static final double THRS = 1.0E-10;
    private static final double sqrt2 = Math.sqrt(2.0);
    private static final double sqrt2p2i_real = Math.sqrt(sqrt2 + 1.0);
    private static final double sqrt2p2i_imag = Math.sqrt(sqrt2 - 1.0);
    private static final double sqrt_2_29 = Math.sqrt(0.06896551724137931);

    @Test
    public void testSqrt() {
        Complex a = new Complex(2.0);
        a.sqrt();
        double err = Math.abs(a.getReal() - sqrt2);
        Assert.assertTrue(err < 1.0E-10);
    }

    @Test
    public void testSqrt_Complex_2_2() {
        Complex a = new Complex(2.0, 2.0);
        a.sqrt();
        double err_real = Math.abs(a.getReal() - sqrt2p2i_real);
        Assert.assertTrue(err_real < 1.0E-10);
        double err_imag = Math.abs(a.getImag() - sqrt2p2i_imag);
        Assert.assertTrue(err_imag < 1.0E-10);
    }

    @Test
    public void testSqrt_Complex_m2_2() {
        Complex a = new Complex(-2.0, 2.0);
        a.sqrt();
        double err_real = Math.abs(a.getReal() - sqrt2p2i_imag);
        Assert.assertTrue(err_real < 1.0E-10);
        double err_imag = Math.abs(a.getImag() - sqrt2p2i_real);
        Assert.assertTrue(err_imag < 1.0E-10);
    }

    @Test
    public void testSqrt_Complex_2_m2() {
        Complex a = new Complex(2.0, -2.0);
        a.sqrt();
        double err_real = Math.abs(a.getReal() - sqrt2p2i_real);
        Assert.assertTrue(err_real < 1.0E-10);
        double err_imag = Math.abs(a.getImag() + sqrt2p2i_imag);
        Assert.assertTrue(err_imag < 1.0E-10);
    }

    @Test
    public void testSqrt_Complex_m2_m2() {
        Complex a = new Complex(-2.0, -2.0);
        a.sqrt();
        double err_real = Math.abs(a.getReal() - sqrt2p2i_imag);
        Assert.assertTrue(err_real < 1.0E-10);
        double err_imag = Math.abs(a.getImag() + sqrt2p2i_real);
        Assert.assertTrue(err_imag < 1.0E-10);
    }

    @Test
    public void testSqrt_Complex_03() {
        Complex a = new Complex(-0.06896551724137931, 0.0);
        a.sqrt();
        double err_real = Math.abs(a.getReal() - 0.0);
        Assert.assertTrue(err_real < 1.0E-10);
        double err_imag = Math.abs(a.getImag() - sqrt_2_29);
        Assert.assertTrue(err_imag < 1.0E-10);
    }
}

