/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.util.maths;

import Jama.Matrix;
import org.ctom.util.maths.Rotation;
import org.ctom.util.maths.VecteurCTOM;

public class Point3D
extends Matrix
implements Cloneable {
    private volatile int hashCode = 0;

    public Point3D(double x, double y, double z) {
        this();
        this.set(0, 0, x);
        this.set(1, 0, y);
        this.set(2, 0, z);
    }

    public Point3D() {
        super(3, 1);
    }

    public Point3D(Point3D p) {
        this();
        this.setX(p.getX());
        this.setY(p.getY());
        this.setZ(p.getZ());
    }

    public boolean isNull() {
        return Double.isNaN(this.getX()) || Double.isNaN(this.getY()) || Double.isNaN(this.getZ());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point3D)) {
            return false;
        }
        Point3D p = (Point3D)o;
        return p.getX() == this.getX() && p.getY() == this.getY() && p.getZ() == this.getZ();
    }

    @Override
    public Object clone() {
        return new Point3D(this);
    }

    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + new Double(this.getX()).hashCode();
            code = 23 * code + new Double(this.getY()).hashCode();
            this.hashCode = code = 23 * code + new Double(this.getZ()).hashCode();
        }
        return this.hashCode;
    }

    public double getX() {
        return this.get(0, 0);
    }

    public double getY() {
        return this.get(1, 0);
    }

    public double getZ() {
        return this.get(2, 0);
    }

    public void setX(double x) {
        this.set(0, 0, x);
    }

    public void setY(double y) {
        this.set(1, 0, y);
    }

    public void setZ(double z) {
        this.set(2, 0, z);
    }

    public double getDistance(Point3D other) {
        return Math.sqrt((this.getX() - other.getX()) * (this.getX() - other.getX()) + (this.getY() - other.getY()) * (this.getY() - other.getY()) + (this.getZ() - other.getZ()) * (this.getZ() - other.getZ()));
    }

    public Point3D plus(Point3D that) {
        Point3D r = new Point3D(this);
        r.plusEquals(that);
        return r;
    }

    public Point3D plusEquals(Point3D that) {
        this.setX(this.getX() + that.getX());
        this.setY(this.getY() + that.getY());
        this.setZ(this.getZ() + that.getZ());
        return this;
    }

    public Point3D translate(VecteurCTOM v) {
        Point3D p = new Point3D(this);
        return p.translateEquals(v);
    }

    public Point3D translateEquals(VecteurCTOM v) {
        this.plusEquals(v);
        return this;
    }

    public Point3D rotate(Rotation mRot) {
        Point3D p = new Point3D(this);
        return p.rotateEquals(mRot);
    }

    public Point3D rotateEquals(Rotation mRot) {
        Matrix mImage = mRot.times(this);
        this.setX(mImage.get(0, 0));
        this.setY(mImage.get(1, 0));
        this.setZ(mImage.get(2, 0));
        return this;
    }

    public Point3D rotate(Point3D around, Rotation mRot) {
        Point3D p = new Point3D(this);
        return p.rotateEquals(around, mRot);
    }

    public Point3D rotateEquals(Point3D around, Rotation mRot) {
        VecteurCTOM vTranslation = new VecteurCTOM(around, this);
        Matrix mImage = mRot.times(vTranslation).plus(around);
        this.setX(mImage.get(0, 0));
        this.setY(mImage.get(1, 0));
        this.setZ(mImage.get(2, 0));
        return this;
    }

    public Point3D rotateAndRenorm(Point3D around, Rotation mRot, double distance) {
        Point3D p = new Point3D(this);
        return p.rotateAndRenormEquals(around, mRot, distance);
    }

    public Point3D rotateAndRenormEquals(Point3D around, Rotation mRot, double distance) {
        Point3D pImage = this.rotate(around, mRot);
        VecteurCTOM v = new VecteurCTOM(around, pImage);
        v.renormEquals(distance);
        pImage = around.translate(v);
        this.setX(pImage.getX());
        this.setY(pImage.getY());
        this.setZ(pImage.getZ());
        return this;
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }
}

