/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.util.maths;

import Jama.Matrix;
import org.ctom.util.maths.VecteurCTOM;

public class Rotation
extends Matrix {
    private VecteurCTOM axis;
    private double angle;

    public static Rotation getRotation3D(VecteurCTOM vect, double angle) {
        VecteurCTOM v = vect.normalize();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        Rotation mRotate = new Rotation(3, 3, v, angle);
        mRotate.set(0, 0, v.getX() * v.getX() + (1.0 - v.getX() * v.getX()) * cos);
        mRotate.set(0, 1, v.getX() * v.getY() * (1.0 - cos) - v.getZ() * sin);
        mRotate.set(0, 2, v.getX() * v.getZ() * (1.0 - cos) + v.getY() * sin);
        mRotate.set(1, 0, v.getX() * v.getY() * (1.0 - cos) + v.getZ() * sin);
        mRotate.set(1, 1, v.getY() * v.getY() + (1.0 - v.getY() * v.getY()) * cos);
        mRotate.set(1, 2, v.getY() * v.getZ() * (1.0 - cos) - v.getX() * sin);
        mRotate.set(2, 0, v.getX() * v.getZ() * (1.0 - cos) - v.getY() * sin);
        mRotate.set(2, 1, v.getY() * v.getZ() * (1.0 - cos) + v.getX() * sin);
        mRotate.set(2, 2, v.getZ() * v.getZ() + (1.0 - v.getZ() * v.getZ()) * cos);
        return mRotate;
    }

    public static Rotation getRotationX(double angle) {
        return Rotation.getRotation3D(VecteurCTOM.V_X_AXIS, angle);
    }

    public static Rotation getRotationY(double angle) {
        return Rotation.getRotation3D(VecteurCTOM.V_Y_AXIS, angle);
    }

    public static Rotation getRotationZ(double angle) {
        return Rotation.getRotation3D(VecteurCTOM.V_Z_AXIS, angle);
    }

    protected Rotation(int nbLine, int nbColumn, VecteurCTOM axis, double angle) {
        super(nbLine, nbColumn);
        this.axis = axis;
        this.angle = angle;
    }

    public VecteurCTOM getAxis() {
        return this.axis;
    }

    public double getAngle() {
        return this.angle;
    }
}

