/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.util.maths;

import Jama.Matrix;
import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.Rotation;

public class VecteurCTOM
extends Point3D {
    public static final VecteurCTOM V_X_AXIS = new VecteurCTOM(1.0, 0.0, 0.0);
    public static final VecteurCTOM V_Y_AXIS = new VecteurCTOM(0.0, 1.0, 0.0);
    public static final VecteurCTOM V_Z_AXIS = new VecteurCTOM(0.0, 0.0, 1.0);

    public VecteurCTOM(double x, double y, double z) {
        super(x, y, z);
    }

    public VecteurCTOM(VecteurCTOM v) {
        super(v);
    }

    public VecteurCTOM(Point3D pA, Point3D pB) {
        super(pB.getX() - pA.getX(), pB.getY() - pA.getY(), pB.getZ() - pA.getZ());
    }

    @Override
    public Object clone() {
        return new VecteurCTOM(this);
    }

    @Override
    public VecteurCTOM times(double d) {
        VecteurCTOM v = new VecteurCTOM(this);
        return v.timesEquals(d);
    }

    @Override
    public VecteurCTOM timesEquals(double d) {
        Matrix m = super.times(d);
        this.setX(m.get(0, 0));
        this.setY(m.get(1, 0));
        this.setZ(m.get(2, 0));
        return this;
    }

    public boolean isInfinite() {
        return super.isNull();
    }

    @Override
    public String toString() {
        return "vector(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    public double getNorm() {
        return Math.sqrt(this.getDotProduct(this));
    }

    public double getDotProduct(VecteurCTOM other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    public double getAngle(VecteurCTOM other) {
        return Math.acos(this.getDotProduct(other) / (this.getNorm() * other.getNorm()));
    }

    public VecteurCTOM getCrossProduct(VecteurCTOM other) {
        double x = this.getY() * other.getZ() - this.getZ() * other.getY();
        double y = this.getZ() * other.getX() - this.getX() * other.getZ();
        double z = this.getX() * other.getY() - this.getY() * other.getX();
        return new VecteurCTOM(x, y, z);
    }

    public VecteurCTOM normalize() {
        VecteurCTOM v = (VecteurCTOM)this.clone();
        return v.normalizeEquals();
    }

    public VecteurCTOM normalizeEquals() {
        double norm = this.getNorm();
        this.setX(this.getX() / norm);
        this.setY(this.getY() / norm);
        this.setZ(this.getZ() / norm);
        return this;
    }

    public VecteurCTOM renorm(double d) {
        return this.normalize().times(d);
    }

    public VecteurCTOM renormEquals(double d) {
        this.normalizeEquals();
        this.timesEquals(d);
        return this;
    }

    @Override
    public VecteurCTOM rotate(Rotation mRot) {
        Point3D afterRotate = super.rotate(mRot);
        double x = afterRotate.get(0, 0);
        double y = afterRotate.get(1, 0);
        double z = afterRotate.get(2, 0);
        return new VecteurCTOM(x, y, z);
    }
}

