/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.util.maths.minimizer;

import Jama.Matrix;
import java.util.ArrayList;
import org.ctom.util.maths.minimizer.MinimizerStop;
import org.ctom.util.maths.minimizer.MultiVariableFunction;
import org.ctom.util.maths.minimizer.PowellMinimizerListener;

public class PowellMinimizer {
    private final MultiVariableFunction function;
    private MinimizerStop stopReason = MinimizerStop.NOREASON;
    private double stopValue = Double.NaN;
    private int nITER_1D;
    private int nITER_nD;
    private boolean verbose = false;
    private boolean microiteration_verbose = false;
    private Matrix PointDepart;
    private double ThrsD;
    private double ThrsV;
    private int NITERMAX;
    private ArrayList<PowellMinimizerListener> listener;

    public MinimizerStop getStopReason() {
        return this.stopReason;
    }

    public double getStopValue() {
        return this.stopValue;
    }

    public boolean addListener(PowellMinimizerListener list) {
        if (this.listener == null) {
            this.listener = new ArrayList();
        }
        return this.listener.add(list);
    }

    private void fireLap(Matrix matrix) {
        for (PowellMinimizerListener l : this.listener) {
            l.intermediateValues(matrix);
        }
    }

    public PowellMinimizer(MultiVariableFunction func) {
        this.function = func;
    }

    public void setOptimizationParameters(Matrix PointDepart, int NITERMAX, double ThrsD, double ThrsV) {
        this.PointDepart = PointDepart;
        this.NITERMAX = NITERMAX;
        this.ThrsD = ThrsD;
        this.ThrsV = ThrsV;
    }

    public Matrix minimize() {
        this.nITER_nD = 0;
        int ndim = this.function.getDimension();
        Matrix matriceDeplacement = Matrix.identity(ndim, ndim);
        Matrix PointActuel = new Matrix(ndim, 1);
        PointActuel = this.PointDepart == null ? new Matrix(ndim, 1) : this.PointDepart.copy();
        Matrix PointPrec = PointActuel.copy();
        double potPrec = this.function.getValue(PointPrec);
        double DistanceParcourue = this.ThrsD + 1.0;
        double dPot = 0.0;
        boolean converged = false;
        if (this.verbose) {
            System.out.printf("%3s\t%3s\t%10s\t%10s\n", "itn", "it1", "dist", "dpot");
        }
        while (!converged) {
            Matrix vecTemp;
            int idim = 0;
            ++this.nITER_nD;
            if (Math.abs(matriceDeplacement.det()) < 0.1) {
                matriceDeplacement = Matrix.identity(ndim, ndim);
            }
            while (idim < ndim) {
                vecTemp = matriceDeplacement.getMatrix(0, ndim - 1, 0, 0);
                PointActuel = this.minimize1D(PointActuel, vecTemp, 1.0, this.ThrsD, this.ThrsV);
                this.rotationMatrice(matriceDeplacement, vecTemp);
                ++idim;
            }
            vecTemp = PointActuel.copy().minus(PointPrec);
            double norm = vecTemp.normF();
            vecTemp.timesEquals(1.0 / norm);
            this.rotationMatrice(matriceDeplacement, vecTemp);
            DistanceParcourue = norm < Double.MIN_VALUE ? 0.0 : norm;
            double potActuel = this.function.getValue(PointActuel);
            dPot = Math.abs(potActuel - potPrec);
            potPrec = potActuel;
            if (this.nITER_nD >= this.NITERMAX) {
                this.stopReason = MinimizerStop.NITERMAX_REACHED;
                this.stopValue = this.nITER_nD;
                break;
            }
            PointPrec = PointActuel.copy();
            if (this.verbose) {
                System.out.printf("%3d\t%3d\t%10.6f\t%10.6f\n", this.nITER_nD, this.nITER_1D, DistanceParcourue, dPot);
            }
            converged = DistanceParcourue < this.ThrsD;
            boolean bl = converged = converged && dPot < this.ThrsV;
            if (converged) {
                this.stopReason = MinimizerStop.CONVERGED;
                this.stopValue = this.nITER_nD;
            }
            if (this.nITER_nD % 1 != 0) continue;
            this.fireLap(PointActuel.copy());
        }
        return PointActuel;
    }

    private void rotationMatrice(Matrix matriceDeplacement, Matrix vecTemp) {
        int ndim = matriceDeplacement.getColumnDimension();
        matriceDeplacement.setMatrix(0, ndim - 1, 0, ndim - 2, matriceDeplacement.getMatrix(0, ndim - 1, 1, ndim - 1));
        matriceDeplacement.setMatrix(0, ndim - 1, ndim - 1, ndim - 1, vecTemp.getMatrix(0, ndim - 1, 0, 0));
    }

    private Matrix minimize1D(Matrix PointActuel, Matrix Direction2, double Delta, double thrsD, double thrsV) {
        double MAGIC = 0.5 * (3.0 - Math.sqrt(5.0));
        Matrix b = PointActuel.copy();
        Matrix x = PointActuel.copy();
        Matrix a = b.copy();
        Matrix c = b.copy();
        a.plusEquals(Direction2.times(-Delta));
        c.plusEquals(Direction2.times(Delta));
        double potA = this.function.getValue(a);
        double potB = this.function.getValue(b);
        double potC = this.function.getValue(c);
        double potX = Math.max(Math.abs(potA), Math.abs(potC));
        double TailleAC = thrsD + 1.0;
        this.nITER_1D = 0;
        double deltaV = Math.abs(potX - Math.abs(potB));
        boolean converged = false;
        if (this.microiteration_verbose) {
            System.out.printf("\t\t%3s\t%10s\t%10s\n", "it1", "delta", "deltaV");
        }
        while (!converged) {
            boolean XdansAB;
            double TailleBC;
            ++this.nITER_1D;
            double TailleAB = a.minus(b).normF();
            if (TailleAB >= (TailleBC = b.minus(c).normF())) {
                x = b.minus(b.minus(a).times(MAGIC));
                XdansAB = true;
            } else {
                x = b.plus(c.minus(b).times(MAGIC));
                XdansAB = false;
            }
            potX = this.function.getValue(x);
            if (XdansAB) {
                if (potX > potB) {
                    a = x;
                    potA = potX;
                } else {
                    c = b;
                    potC = potB;
                    b = x;
                    potB = potX;
                }
            } else if (potX > potB) {
                c = x;
                potC = potX;
            } else {
                a = b;
                potA = potB;
                b = x;
                potB = potX;
            }
            PointActuel = x;
            TailleAC = a.minus(c).normF();
            deltaV = Math.abs(potC - potA);
            boolean bl = converged = TailleAC < thrsD && deltaV < thrsV;
            if (!this.microiteration_verbose) continue;
            System.out.printf("\t\t%3d\t%10.6f\t%10.6f\n", this.nITER_1D, TailleAC, deltaV);
        }
        return PointActuel;
    }
}

