/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.util.maths.minimizer;

import Jama.Matrix;
import org.ctom.util.maths.minimizer.MultiVariableFunctionTEST;
import org.ctom.util.maths.minimizer.PowellMinimizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PowellMinimizerTest {
    private PowellMinimizer opt;
    private MultiVariableFunctionTEST mExpm10xm22 = new MultiVariableFunctionTEST(){

        @Override
        public double getValue(Matrix v) {
            double x = v.get(0, 0);
            return -Math.exp(-10.0 * (x - 2.0) * (x - 2.0));
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public Matrix getOpt() {
            return new Matrix(new double[][]{{2.0}});
        }
    };
    private MultiVariableFunctionTEST MMH2O = new MultiVariableFunctionTEST(){

        @Override
        public double getValue(Matrix v) {
            double oh1 = v.get(0, 0);
            double oh2 = v.get(1, 0);
            double hoh = v.get(2, 0);
            double OH0 = 0.95;
            double HOH0 = 109.45;
            double kOH = 10000.0;
            double kHOH = 1.0;
            return kOH * Math.pow(oh1 - OH0, 2.0) + kOH * Math.pow(oh2 - OH0, 2.0) + kHOH * Math.pow(hoh - HOH0, 2.0);
        }

        @Override
        public int getDimension() {
            return 3;
        }

        @Override
        public Matrix getOpt() {
            return new Matrix(new double[][]{{0.95}, {0.95}, {109.45}});
        }
    };

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testMinimize() {
        this.opt = new PowellMinimizer(this.mExpm10xm22);
        double thrs = 1.0E-6;
        this.opt.setOptimizationParameters(null, 100, thrs, thrs);
        Matrix pointOpt = this.opt.minimize();
        System.out.println("TARGET :");
        this.mExpm10xm22.getOpt().print(10, 5);
        System.out.println("OPTIMUM FOUND :");
        pointOpt.print(10, 5);
        double norm = pointOpt.minus(this.mExpm10xm22.getOpt()).normF();
        System.out.println("Norm: " + norm + " " + (norm < thrs));
        Assert.assertTrue(norm < thrs);
    }

    @Test
    public void testMinimize2() {
        this.opt = new PowellMinimizer(this.MMH2O);
        double thrs = 1.0E-6;
        this.opt.setOptimizationParameters(new Matrix(new double[][]{{1.1}, {1.1}, {100.0}}), 100, thrs, thrs);
        Matrix pointOpt = this.opt.minimize();
        System.out.println("TARGET :");
        this.MMH2O.getOpt().print(10, 5);
        System.out.println("OPTIMUM FOUND :");
        pointOpt.print(10, 5);
        double norm = pointOpt.minus(this.MMH2O.getOpt()).normF();
        System.out.println("Norm: " + norm + " " + (norm < thrs));
        Assert.assertTrue(norm < thrs);
    }
}

