/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.util.time;

import java.util.HashMap;
import java.util.Map;
import org.ctom.util.maths.Maths;

public class CTOMProfiler {
    private static HashMap<String, Info> listTemps = new HashMap();
    private static CTOMProfiler instance = null;

    public static CTOMProfiler getInstance() {
        if (instance == null) {
            instance = new CTOMProfiler();
        }
        return instance;
    }

    public void debut(String str) {
        Info info;
        if (!listTemps.containsKey(str)) {
            info = new Info();
            listTemps.put(str, info);
        } else {
            info = listTemps.get(str);
        }
        info.setDebut();
    }

    public void fin(String str) {
        Info info = listTemps.get(str);
        info.setFin();
    }

    public HashMap<String, Info> getTimings() {
        return (HashMap)listTemps.clone();
    }

    public String toHTML() {
        String buffer = "";
        HashMap<String, Info> map = this.getTimings();
        buffer = String.valueOf(buffer) + "<table>";
        buffer = String.valueOf(buffer) + "<tr><td>nom methode</td><td>nb appels</td><td>tot duree(ms)</td><td>moy duree(ms)</td><td> % duree</td></tr>";
        long dureeTotale = 0L;
        for (Map.Entry<String, Info> entry : map.entrySet()) {
            Info info = entry.getValue();
            dureeTotale += info.getTempsTotal();
        }
        for (Map.Entry<String, Info> entry : map.entrySet()) {
            String routine = entry.getKey();
            Info info = entry.getValue();
            buffer = String.valueOf(buffer) + "<tr><td>" + routine + "</td><td class=\"text-align:right\">" + info.getNbAppels() + "</td><td class=\"text-align:right\">" + info.getTempsTotal() + "</td><td class=\"text-align:right\">" + Maths.round(info.getTempsTotal() / (long)info.getNbAppels(), 1) + "</td><td class=\"text-align:right\">" + Maths.round((double)info.getTempsTotal() / (double)dureeTotale * 100.0, 2) + "</td></tr>";
        }
        buffer = String.valueOf(buffer) + "</table>";
        return buffer;
    }

    protected class Info {
        private int nbreAppel = 0;
        private long tempsDebut;
        private long tempsFin;
        private long tempsTotal = 0L;

        protected Info() {
        }

        void ajoutAppel() {
            ++this.nbreAppel;
        }

        void setDebut() {
            this.ajoutAppel();
            this.tempsDebut = System.currentTimeMillis();
        }

        void setFin() {
            this.tempsFin = System.currentTimeMillis();
            this.tempsTotal += this.tempsFin - this.tempsDebut;
        }

        public int getNbAppels() {
            return this.nbreAppel;
        }

        public long getTempsTotal() {
            return this.tempsTotal;
        }
    }
}

