/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class StandardEntityCollection
implements EntityCollection,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5384773031184897047L;
    private List entities = new ArrayList();

    @Override
    public int getEntityCount() {
        return this.entities.size();
    }

    @Override
    public ChartEntity getEntity(int index) {
        return (ChartEntity)this.entities.get(index);
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public void add(ChartEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null 'entity' argument.");
        }
        this.entities.add(entity);
    }

    @Override
    public void addAll(EntityCollection collection) {
        this.entities.addAll(collection.getEntities());
    }

    @Override
    public ChartEntity getEntity(double x, double y) {
        int entityCount = this.entities.size();
        int i2 = entityCount - 1;
        while (i2 >= 0) {
            ChartEntity entity = (ChartEntity)this.entities.get(i2);
            if (entity.getArea().contains(x, y)) {
                return entity;
            }
            --i2;
        }
        return null;
    }

    @Override
    public Collection getEntities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    @Override
    public Iterator iterator() {
        return this.entities.iterator();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardEntityCollection) {
            StandardEntityCollection that = (StandardEntityCollection)obj;
            return ObjectUtilities.equal(this.entities, that.entities);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StandardEntityCollection clone = (StandardEntityCollection)super.clone();
        clone.entities = new ArrayList(this.entities.size());
        int i2 = 0;
        while (i2 < this.entities.size()) {
            ChartEntity entity = (ChartEntity)this.entities.get(i2);
            clone.entities.add(entity.clone());
            ++i2;
        }
        return clone;
    }
}

