/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Arrays;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static boolean equal(double[][] a, double[][] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < a.length) {
            if (!Arrays.equals(a[i2], b[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static double[][] clone(double[][] source) {
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        double[][] clone = new double[source.length][];
        int i2 = 0;
        while (i2 < source.length) {
            if (source[i2] != null) {
                double[] row = new double[source[i2].length];
                System.arraycopy(source[i2], 0, row, 0, source[i2].length);
                clone[i2] = row;
            }
            ++i2;
        }
        return clone;
    }

    public static double calculateColumnTotal(Values2D data, int column) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int rowCount = data.getRowCount();
        int r = 0;
        while (r < rowCount) {
            Number n = data.getValue(r, column);
            if (n != null) {
                total += n.doubleValue();
            }
            ++r;
        }
        return total;
    }

    public static double calculateColumnTotal(Values2D data, int column, int[] validRows) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int rowCount = data.getRowCount();
        int v = 0;
        while (v < validRows.length) {
            Number n;
            int row = validRows[v];
            if (row < rowCount && (n = data.getValue(row, column)) != null) {
                total += n.doubleValue();
            }
            ++v;
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int columnCount = data.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            Number n = data.getValue(row, c);
            if (n != null) {
                total += n.doubleValue();
            }
            ++c;
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row, int[] validCols) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double total = 0.0;
        int colCount = data.getColumnCount();
        int v = 0;
        while (v < validCols.length) {
            Number n;
            int col = validCols[v];
            if (col < colCount && (n = data.getValue(row, col)) != null) {
                total += n.doubleValue();
            }
            ++v;
        }
        return total;
    }

    public static Number[] createNumberArray(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] result = new Number[data.length];
        int i2 = 0;
        while (i2 < data.length) {
            result[i2] = new Double(data[i2]);
            ++i2;
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int l1 = data.length;
        Number[][] result = new Number[l1][];
        int i2 = 0;
        while (i2 < l1) {
            result[i2] = DataUtilities.createNumberArray(data[i2]);
            ++i2;
        }
        return result;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues result = new DefaultKeyedValues();
        double total = 0.0;
        int i2 = 0;
        while (i2 < data.getItemCount()) {
            Number v = data.getValue(i2);
            if (v != null) {
                total += v.doubleValue();
            }
            ++i2;
        }
        double runningTotal = 0.0;
        int i3 = 0;
        while (i3 < data.getItemCount()) {
            Number v = data.getValue(i3);
            if (v != null) {
                runningTotal += v.doubleValue();
            }
            result.addValue(data.getKey(i3), new Double(runningTotal / total));
            ++i3;
        }
        return result;
    }
}

