/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.util.Collections;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class CategoryToPieDataset
extends AbstractDataset
implements PieDataset,
DatasetChangeListener {
    static final long serialVersionUID = 5516396319762189617L;
    private CategoryDataset source;
    private TableOrder extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset source, TableOrder extract, int index) {
        if (extract == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.source = source;
        if (this.source != null) {
            this.source.addChangeListener(this);
        }
        this.extract = extract;
        this.index = index;
    }

    public CategoryDataset getUnderlyingDataset() {
        return this.source;
    }

    public TableOrder getExtractType() {
        return this.extract;
    }

    public int getExtractIndex() {
        return this.index;
    }

    @Override
    public int getItemCount() {
        int result = 0;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                result = this.source.getColumnCount();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                result = this.source.getRowCount();
            }
        }
        return result;
    }

    @Override
    public Number getValue(int item) {
        Number result = null;
        if (item < 0 || item >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("The 'item' index is out of bounds.");
        }
        if (this.extract == TableOrder.BY_ROW) {
            result = this.source.getValue(this.index, item);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            result = this.source.getValue(item, this.index);
        }
        return result;
    }

    @Override
    public Comparable getKey(int index) {
        Comparable result = null;
        if (index < 0 || index >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("Invalid 'index': " + index);
        }
        if (this.extract == TableOrder.BY_ROW) {
            result = this.source.getColumnKey(index);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            result = this.source.getRowKey(index);
        }
        return result;
    }

    @Override
    public int getIndex(Comparable key) {
        int result = -1;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                result = this.source.getColumnIndex(key);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                result = this.source.getRowIndex(key);
            }
        }
        return result;
    }

    @Override
    public List getKeys() {
        List result = Collections.EMPTY_LIST;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                result = this.source.getColumnKeys();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                result = this.source.getRowKeys();
            }
        }
        return result;
    }

    @Override
    public Number getValue(Comparable key) {
        Number result = null;
        int keyIndex = this.getIndex(key);
        if (keyIndex != -1) {
            if (this.extract == TableOrder.BY_ROW) {
                result = this.source.getValue(this.index, keyIndex);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                result = this.source.getValue(keyIndex, this.index);
            }
        }
        return result;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PieDataset)) {
            return false;
        }
        PieDataset that = (PieDataset)obj;
        int count = this.getItemCount();
        if (that.getItemCount() != count) {
            return false;
        }
        int i2 = 0;
        while (i2 < count) {
            Comparable k2;
            Comparable k1 = this.getKey(i2);
            if (!k1.equals(k2 = that.getKey(i2))) {
                return false;
            }
            Number v1 = this.getValue(i2);
            Number v2 = that.getValue(i2);
            if (v1 == null ? v2 != null : !v1.equals(v2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

