/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.contour;

import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.Range;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.xy.AbstractXYZDataset;

public class DefaultContourDataset
extends AbstractXYZDataset
implements ContourDataset {
    protected Comparable seriesKey = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(Comparable seriesKey, Object[] xData, Object[] yData, Object[] zData) {
        this.seriesKey = seriesKey;
        this.initialize(xData, yData, zData);
    }

    public void initialize(Object[] xData, Object[] yData, Object[] zData) {
        this.xValues = new Double[xData.length];
        this.yValues = new Double[yData.length];
        this.zValues = new Double[zData.length];
        Vector<Integer> tmpVector = new Vector<Integer>();
        double x = 1.123452E31;
        int k = 0;
        while (k < this.xValues.length) {
            if (xData[k] != null) {
                Number xNumber;
                if (xData[k] instanceof Number) {
                    xNumber = (Number)xData[k];
                } else if (xData[k] instanceof Date) {
                    this.dateAxis[0] = true;
                    Date xDate = (Date)xData[k];
                    xNumber = new Long(xDate.getTime());
                } else {
                    xNumber = new Integer(0);
                }
                this.xValues[k] = new Double(xNumber.doubleValue());
                if (x != this.xValues[k].doubleValue()) {
                    tmpVector.add(new Integer(k));
                    x = this.xValues[k].doubleValue();
                }
            }
            ++k;
        }
        Object[] inttmp = tmpVector.toArray();
        this.xIndex = new int[inttmp.length];
        int i2 = 0;
        while (i2 < inttmp.length) {
            this.xIndex[i2] = (Integer)inttmp[i2];
            ++i2;
        }
        int k2 = 0;
        while (k2 < this.yValues.length) {
            this.yValues[k2] = (Double)yData[k2];
            if (zData[k2] != null) {
                this.zValues[k2] = (Double)zData[k2];
            }
            ++k2;
        }
    }

    public static Object[][] formObjectArray(double[][] data) {
        Object[][] object = new Double[data.length][data[0].length];
        int i2 = 0;
        while (i2 < object.length) {
            int j = 0;
            while (j < object[i2].length) {
                object[i2][j] = new Double(data[i2][j]);
                ++j;
            }
            ++i2;
        }
        return object;
    }

    public static Object[] formObjectArray(double[] data) {
        Object[] object = new Double[data.length];
        int i2 = 0;
        while (i2 < object.length) {
            object[i2] = new Double(data[i2]);
            ++i2;
        }
        return object;
    }

    @Override
    public int getItemCount(int series) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues.length;
    }

    @Override
    public double getMaxZValue() {
        double zMax = -1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.zValues[k] != null) {
                zMax = Math.max(zMax, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return zMax;
    }

    @Override
    public double getMinZValue() {
        double zMin = 1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.zValues[k] != null) {
                zMin = Math.min(zMin, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return zMin;
    }

    @Override
    public Range getZValueRange(Range x, Range y) {
        double minX = x.getLowerBound();
        double minY = y.getLowerBound();
        double maxX = x.getUpperBound();
        double maxY = y.getUpperBound();
        double zMin = 1.0E20;
        double zMax = -1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.xValues[k].doubleValue() >= minX && this.xValues[k].doubleValue() <= maxX && this.yValues[k].doubleValue() >= minY && this.yValues[k].doubleValue() <= maxY && this.zValues[k] != null) {
                zMin = Math.min(zMin, this.zValues[k].doubleValue());
                zMax = Math.max(zMax, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return new Range(zMin, zMax);
    }

    public double getMinZValue(double minX, double minY, double maxX, double maxY) {
        double zMin = 1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.zValues[k] != null) {
                zMin = Math.min(zMin, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return zMin;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public Comparable getSeriesKey(int series) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.seriesKey;
    }

    @Override
    public int[] getXIndices() {
        return this.xIndex;
    }

    @Override
    public Number[] getXValues() {
        return this.xValues;
    }

    @Override
    public Number getX(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.xValues[item];
    }

    public Number getXValue(int item) {
        return this.xValues[item];
    }

    @Override
    public Number[] getYValues() {
        return this.yValues;
    }

    @Override
    public Number getY(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.yValues[item];
    }

    @Override
    public Number[] getZValues() {
        return this.zValues;
    }

    @Override
    public Number getZ(int series, int item) {
        if (series > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues[item];
    }

    @Override
    public int[] indexX() {
        int[] index = new int[this.xValues.length];
        int k = 0;
        while (k < index.length) {
            index[k] = this.indexX(k);
            ++k;
        }
        return index;
    }

    public int indexX(int k) {
        int i2 = Arrays.binarySearch(this.xIndex, k);
        if (i2 >= 0) {
            return i2;
        }
        return -1 * i2 - 2;
    }

    public int indexY(int k) {
        return k / this.xValues.length;
    }

    public int indexZ(int i2, int j) {
        return this.xValues.length * j + i2;
    }

    @Override
    public boolean isDateAxis(int axisNumber) {
        if (axisNumber < 0 || axisNumber > 2) {
            return false;
        }
        return this.dateAxis[axisNumber];
    }

    public void setSeriesKeys(Comparable[] seriesKeys) {
        if (seriesKeys.length > 1) {
            throw new IllegalArgumentException("Contours only support one series");
        }
        this.seriesKey = seriesKeys[0];
        this.fireDatasetChanged();
    }
}

