/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MovingAverage {
    public static TimeSeriesCollection createMovingAverage(TimeSeriesCollection source, String suffix, int periodCount, int skip) {
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        if (periodCount < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeriesCollection result = new TimeSeriesCollection();
        int i2 = 0;
        while (i2 < source.getSeriesCount()) {
            TimeSeries sourceSeries = source.getSeries(i2);
            TimeSeries maSeries = MovingAverage.createMovingAverage(sourceSeries, sourceSeries.getKey() + suffix, periodCount, skip);
            result.addSeries(maSeries);
            ++i2;
        }
        return result;
    }

    public static TimeSeries createMovingAverage(TimeSeries source, String name, int periodCount, int skip) {
        if (source == null) {
            throw new IllegalArgumentException("Null source.");
        }
        if (periodCount < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeries result = new TimeSeries((Comparable)((Object)name));
        if (source.getItemCount() > 0) {
            long firstSerial = source.getTimePeriod(0).getSerialIndex() + (long)skip;
            int i2 = source.getItemCount() - 1;
            while (i2 >= 0) {
                RegularTimePeriod period = source.getTimePeriod(i2);
                long serial = period.getSerialIndex();
                if (serial >= firstSerial) {
                    int n = 0;
                    double sum = 0.0;
                    long serialLimit = period.getSerialIndex() - (long)periodCount;
                    int offset = 0;
                    boolean finished = false;
                    while (offset < periodCount && !finished) {
                        if (i2 - offset >= 0) {
                            TimeSeriesDataItem item = source.getRawDataItem(i2 - offset);
                            RegularTimePeriod p = item.getPeriod();
                            Number v = item.getValue();
                            long currentIndex = p.getSerialIndex();
                            if (currentIndex > serialLimit) {
                                if (v != null) {
                                    sum += v.doubleValue();
                                    ++n;
                                }
                            } else {
                                finished = true;
                            }
                        }
                        ++offset;
                    }
                    if (n > 0) {
                        result.add(period, sum / (double)n);
                    } else {
                        result.add(period, null);
                    }
                }
                --i2;
            }
        }
        return result;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries source, String name, int pointCount) {
        if (source == null) {
            throw new IllegalArgumentException("Null 'source'.");
        }
        if (pointCount < 2) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 2.");
        }
        TimeSeries result = new TimeSeries((Comparable)((Object)name));
        double rollingSumForPeriod = 0.0;
        int i2 = 0;
        while (i2 < source.getItemCount()) {
            TimeSeriesDataItem current = source.getRawDataItem(i2);
            RegularTimePeriod period = current.getPeriod();
            rollingSumForPeriod += current.getValue().doubleValue();
            if (i2 > pointCount - 1) {
                TimeSeriesDataItem startOfMovingAvg = source.getRawDataItem(i2 - pointCount);
                result.add(period, (rollingSumForPeriod -= startOfMovingAvg.getValue().doubleValue()) / (double)pointCount);
            } else if (i2 == pointCount - 1) {
                result.add(period, rollingSumForPeriod / (double)pointCount);
            }
            ++i2;
        }
        return result;
    }

    public static XYDataset createMovingAverage(XYDataset source, String suffix, long period, long skip) {
        return MovingAverage.createMovingAverage(source, suffix, (double)period, (double)skip);
    }

    public static XYDataset createMovingAverage(XYDataset source, String suffix, double period, double skip) {
        if (source == null) {
            throw new IllegalArgumentException("Null source (XYDataset).");
        }
        XYSeriesCollection result = new XYSeriesCollection();
        int i2 = 0;
        while (i2 < source.getSeriesCount()) {
            XYSeries s = MovingAverage.createMovingAverage(source, i2, source.getSeriesKey(i2) + suffix, period, skip);
            result.addSeries(s);
            ++i2;
        }
        return result;
    }

    public static XYSeries createMovingAverage(XYDataset source, int series, String name, double period, double skip) {
        if (source == null) {
            throw new IllegalArgumentException("Null source (XYDataset).");
        }
        if (period < Double.MIN_VALUE) {
            throw new IllegalArgumentException("period must be positive.");
        }
        if (skip < 0.0) {
            throw new IllegalArgumentException("skip must be >= 0.0.");
        }
        XYSeries result = new XYSeries((Comparable)((Object)name));
        if (source.getItemCount(series) > 0) {
            double first = source.getXValue(series, 0) + skip;
            int i2 = source.getItemCount(series) - 1;
            while (i2 >= 0) {
                double x = source.getXValue(series, i2);
                if (x >= first) {
                    int n = 0;
                    double sum = 0.0;
                    double limit = x - period;
                    int offset = 0;
                    boolean finished = false;
                    while (!finished) {
                        if (i2 - offset >= 0) {
                            double xx = source.getXValue(series, i2 - offset);
                            Number yy = source.getY(series, i2 - offset);
                            if (xx > limit) {
                                if (yy != null) {
                                    sum += yy.doubleValue();
                                    ++n;
                                }
                            } else {
                                finished = true;
                            }
                        } else {
                            finished = true;
                        }
                        ++offset;
                    }
                    if (n > 0) {
                        result.add(x, sum / (double)n);
                    } else {
                        result.add(x, (Number)null);
                    }
                }
                --i2;
            }
        }
        return result;
    }
}

