/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.date.SerialDate;

public class SerialDateTests
extends TestCase {
    private SerialDate nov9Y2001;

    public SerialDateTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite((Class<?>)SerialDateTests.class);
    }

    @Override
    protected void setUp() {
        this.nov9Y2001 = SerialDate.createInstance(9, 11, 2001);
    }

    public void testAddMonthsTo9Nov2001() {
        SerialDate jan9Y2002 = SerialDate.addMonths(2, this.nov9Y2001);
        SerialDate answer = SerialDate.createInstance(9, 1, 2002);
        SerialDateTests.assertEquals(answer, jan9Y2002);
    }

    public void testAddMonthsTo5Oct2003() {
        SerialDate d1 = SerialDate.createInstance(5, 10, 2003);
        SerialDate d2 = SerialDate.addMonths(2, d1);
        SerialDateTests.assertEquals(d2, SerialDate.createInstance(5, 12, 2003));
    }

    public void testAddMonthsTo1Jan2003() {
        SerialDate d1 = SerialDate.createInstance(1, 1, 2003);
        SerialDate d2 = SerialDate.addMonths(0, d1);
        SerialDateTests.assertEquals(d2, d1);
    }

    public void testMondayPrecedingFriday9Nov2001() {
        SerialDate mondayBefore = SerialDate.getPreviousDayOfWeek(2, this.nov9Y2001);
        SerialDateTests.assertEquals(5, mondayBefore.getDayOfMonth());
    }

    public void testMondayFollowingFriday9Nov2001() {
        SerialDate mondayAfter = SerialDate.getFollowingDayOfWeek(2, this.nov9Y2001);
        SerialDateTests.assertEquals(12, mondayAfter.getDayOfMonth());
    }

    public void testMondayNearestFriday9Nov2001() {
        SerialDate mondayNearest = SerialDate.getNearestDayOfWeek(2, this.nov9Y2001);
        SerialDateTests.assertEquals(12, mondayNearest.getDayOfMonth());
    }

    public void testMondayNearest22Jan1970() {
        SerialDate jan22Y1970 = SerialDate.createInstance(22, 1, 1970);
        SerialDate mondayNearest = SerialDate.getNearestDayOfWeek(2, jan22Y1970);
        SerialDateTests.assertEquals(19, mondayNearest.getDayOfMonth());
    }

    public void testWeekdayCodeToString() {
        String test = SerialDate.weekdayCodeToString(7);
        SerialDateTests.assertEquals("Saturday", test);
    }

    public void testStringToWeekday() {
        int weekday = SerialDate.stringToWeekdayCode("Wednesday");
        SerialDateTests.assertEquals(4, weekday);
        weekday = SerialDate.stringToWeekdayCode(" Wednesday ");
        SerialDateTests.assertEquals(4, weekday);
        weekday = SerialDate.stringToWeekdayCode("Wed");
        SerialDateTests.assertEquals(4, weekday);
    }

    public void testStringToMonthCode() {
        int m = SerialDate.stringToMonthCode("January");
        SerialDateTests.assertEquals(1, m);
        m = SerialDate.stringToMonthCode(" January ");
        SerialDateTests.assertEquals(1, m);
        m = SerialDate.stringToMonthCode("Jan");
        SerialDateTests.assertEquals(1, m);
    }

    public void testMonthCodeToStringCode() {
        String test = SerialDate.monthCodeToString(12);
        SerialDateTests.assertEquals("December", test);
    }

    public void testIsNotLeapYear1900() {
        SerialDateTests.assertTrue(!SerialDate.isLeapYear(1900));
    }

    public void testIsLeapYear2000() {
        SerialDateTests.assertTrue(SerialDate.isLeapYear(2000));
    }

    public void testLeapYearCount1899() {
        SerialDateTests.assertEquals(SerialDate.leapYearCount(1899), 0);
    }

    public void testLeapYearCount1903() {
        SerialDateTests.assertEquals(SerialDate.leapYearCount(1903), 0);
    }

    public void testLeapYearCount1904() {
        SerialDateTests.assertEquals(SerialDate.leapYearCount(1904), 1);
    }

    public void testLeapYearCount1999() {
        SerialDateTests.assertEquals(SerialDate.leapYearCount(1999), 24);
    }

    public void testLeapYearCount2000() {
        SerialDateTests.assertEquals(SerialDate.leapYearCount(2000), 25);
    }

    public void testSerialization() {
        SerialDate d1 = SerialDate.createInstance(15, 4, 2000);
        SerialDate d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (SerialDate)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SerialDateTests.assertEquals(d1, d2);
    }

    public void test1096282() {
        SerialDate d = SerialDate.createInstance(29, 2, 2004);
        d = SerialDate.addYears(1, d);
        SerialDate expected = SerialDate.createInstance(28, 2, 2005);
        SerialDateTests.assertTrue(d.isOn(expected));
    }

    public void testAddMonths() {
        SerialDate d1 = SerialDate.createInstance(31, 5, 2004);
        SerialDate d2 = SerialDate.addMonths(1, d1);
        SerialDateTests.assertEquals(30, d2.getDayOfMonth());
        SerialDateTests.assertEquals(6, d2.getMonth());
        SerialDateTests.assertEquals(2004, d2.getYYYY());
        SerialDate d3 = SerialDate.addMonths(2, d1);
        SerialDateTests.assertEquals(31, d3.getDayOfMonth());
        SerialDateTests.assertEquals(7, d3.getMonth());
        SerialDateTests.assertEquals(2004, d3.getYYYY());
        SerialDate d4 = SerialDate.addMonths(1, SerialDate.addMonths(1, d1));
        SerialDateTests.assertEquals(30, d4.getDayOfMonth());
        SerialDateTests.assertEquals(7, d4.getMonth());
        SerialDateTests.assertEquals(2004, d4.getYYYY());
    }
}

