/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.date.SerialDate;
import org.jfree.date.SpreadsheetDate;

public class SpreadsheetDateTests
extends TestCase {
    private SerialDate jan1Y1900;
    private SerialDate s2;

    public static Test suite() {
        return new TestSuite((Class<?>)SpreadsheetDateTests.class);
    }

    public SpreadsheetDateTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() {
        this.jan1Y1900 = new SpreadsheetDate(1, 1, 1900);
        this.s2 = new SpreadsheetDate(2);
    }

    public void test1Jan1900GetDayOfWeek() {
        int dayOfWeek = this.jan1Y1900.getDayOfWeek();
        SpreadsheetDateTests.assertEquals(2, dayOfWeek);
    }

    public void test12Nov2001GetDayOfWeek() {
        SpreadsheetDate nov12Y2001 = new SpreadsheetDate(12, 11, 2001);
        int dayOfWeek = ((SerialDate)nov12Y2001).getDayOfWeek();
        SpreadsheetDateTests.assertEquals(2, dayOfWeek);
    }

    public void testS2GetDayOfMonth() {
        int dayOfMonth = this.s2.getDayOfMonth();
        SpreadsheetDateTests.assertEquals(1, dayOfMonth);
    }

    public void testS2GetMonth() {
        int month = this.s2.getMonth();
        SpreadsheetDateTests.assertEquals(1, month);
    }

    public void testS2GetYYYY() {
        int year = this.s2.getYYYY();
        SpreadsheetDateTests.assertEquals(1900, year);
    }

    public void test37986() {
        SpreadsheetDate d = new SpreadsheetDate(37986);
        SpreadsheetDateTests.assertEquals(31, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(12, d.getMonth());
        SpreadsheetDateTests.assertEquals(2003, d.getYYYY());
    }

    public void test37987() {
        SpreadsheetDate d = new SpreadsheetDate(37987);
        SpreadsheetDateTests.assertEquals(1, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(1, d.getMonth());
        SpreadsheetDateTests.assertEquals(2004, d.getYYYY());
    }

    public void test38352() {
        SpreadsheetDate d = new SpreadsheetDate(38352);
        SpreadsheetDateTests.assertEquals(31, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(12, d.getMonth());
        SpreadsheetDateTests.assertEquals(2004, d.getYYYY());
    }

    public void test38353() {
        SpreadsheetDate d = new SpreadsheetDate(38353);
        SpreadsheetDateTests.assertEquals(1, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(1, d.getMonth());
        SpreadsheetDateTests.assertEquals(2005, d.getYYYY());
    }

    public void test36584() {
        SpreadsheetDate d = new SpreadsheetDate(36584);
        SpreadsheetDateTests.assertEquals(28, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(2, d.getMonth());
        SpreadsheetDateTests.assertEquals(2000, d.getYYYY());
    }

    public void test36585() {
        SpreadsheetDate d = new SpreadsheetDate(36585);
        SpreadsheetDateTests.assertEquals(29, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(2, d.getMonth());
        SpreadsheetDateTests.assertEquals(2000, d.getYYYY());
    }

    public void test36586() {
        SpreadsheetDate d = new SpreadsheetDate(36586);
        SpreadsheetDateTests.assertEquals(1, d.getDayOfMonth());
        SpreadsheetDateTests.assertEquals(3, d.getMonth());
        SpreadsheetDateTests.assertEquals(2000, d.getYYYY());
    }

    public void test01Jan1900ToSerial() {
        int serial = this.jan1Y1900.toSerial();
        SpreadsheetDateTests.assertEquals(2, serial);
    }

    public void test28Feb1900ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(28, 2, 1900);
        SpreadsheetDateTests.assertEquals(60, d.toSerial());
    }

    public void test01Mar1900ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 3, 1900);
        SpreadsheetDateTests.assertEquals(61, d.toSerial());
    }

    public void test31Dec1999ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(31, 12, 1999);
        SpreadsheetDateTests.assertEquals(36525, d.toSerial());
    }

    public void test01Jan2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 1, 2000);
        SpreadsheetDateTests.assertEquals(36526, d.toSerial());
    }

    public void test31Jan2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(31, 1, 2000);
        SpreadsheetDateTests.assertEquals(36556, d.toSerial());
    }

    public void test01Feb2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 2, 2000);
        SpreadsheetDateTests.assertEquals(36557, d.toSerial());
    }

    public void test28Feb2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(28, 2, 2000);
        SpreadsheetDateTests.assertEquals(36584, d.toSerial());
    }

    public void test29feb2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(29, 2, 2000);
        SpreadsheetDateTests.assertEquals(36585, d.toSerial());
    }

    public void test1mar2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 3, 2000);
        SpreadsheetDateTests.assertEquals(36586, d.toSerial());
    }

    public void testSerialization() {
        SpreadsheetDate d1 = new SpreadsheetDate(15, 4, 2000);
        SpreadsheetDate d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (SpreadsheetDate)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SpreadsheetDateTests.assertEquals(d1, d2);
    }

    public void testGetDescription() {
        SpreadsheetDate d1 = new SpreadsheetDate(15, 4, 2000);
        SpreadsheetDateTests.assertEquals(null, d1.getDescription());
        d1.setDescription("XYZ");
        SpreadsheetDateTests.assertEquals("XYZ", d1.getDescription());
    }

    public void testSetDescription() {
        SpreadsheetDate d1 = new SpreadsheetDate(15, 4, 2000);
        SpreadsheetDateTests.assertEquals(null, d1.getDescription());
        d1.setDescription("XYZ");
        SpreadsheetDateTests.assertEquals("XYZ", d1.getDescription());
        d1.setDescription(null);
        SpreadsheetDateTests.assertEquals(null, d1.getDescription());
    }
}

