/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io.junit;

import java.io.IOException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.io.IOUtils;

public class IOUtilsTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)IOUtilsTests.class);
    }

    public IOUtilsTests() {
    }

    public IOUtilsTests(String name) {
        super(name);
    }

    public void testCreateRelativeURL() throws IOException {
        URL baseurl = new URL("http://test.com:80/test/a/funny/directory/basefile.xml");
        URL testInput1 = new URL("http://test.com:80/test/a/funny/directory/datafile.jpg");
        String result = IOUtils.getInstance().createRelativeURL(testInput1, baseurl);
        IOUtilsTests.assertEquals("datafile.jpg", result);
        IOUtilsTests.assertEquals(testInput1, new URL(baseurl, result));
        URL testInput2 = new URL("http://test.com:80/test/adatafile.jpg");
        result = IOUtils.getInstance().createRelativeURL(testInput2, baseurl);
        IOUtilsTests.assertEquals("../../../adatafile.jpg", result);
        IOUtilsTests.assertEquals(testInput2, new URL(baseurl, result));
        URL testInput3 = new URL("http://test.com:80/test/adatafile.jpg?query=test");
        result = IOUtils.getInstance().createRelativeURL(testInput3, baseurl);
        IOUtilsTests.assertEquals("../../../adatafile.jpg?query=test", result);
        IOUtilsTests.assertEquals(testInput3, new URL(baseurl, result));
    }
}

