/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io.junit;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedString;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.io.SerialUtilities;
import org.jfree.util.AttributedStringUtilities;
import org.jfree.util.ShapeUtilities;

public class SerialUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)SerialUtilitiesTests.class);
    }

    public SerialUtilitiesTests(String name) {
        super(name);
    }

    public void testIsSerializable() {
        SerialUtilitiesTests.assertTrue(SerialUtilities.isSerializable(Color.class));
        SerialUtilitiesTests.assertTrue(SerialUtilities.isSerializable(ColorUIResource.class));
        SerialUtilitiesTests.assertFalse(SerialUtilities.isSerializable(GradientPaint.class));
        SerialUtilitiesTests.assertFalse(SerialUtilities.isSerializable(TexturePaint.class));
    }

    public void testColorSerialization() {
        Color p1 = Color.blue;
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertEquals(p1, p2);
    }

    public void testColorUIResourceSerialization() {
        Color p1 = UIManager.getColor("Panel.background");
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            SerialUtilitiesTests.fail(e.toString());
        }
        SerialUtilitiesTests.assertEquals(p1, p2);
    }

    public void testGradientPaintSerialization() {
        GradientPaint p1 = new GradientPaint(0.0f, 0.0f, Color.blue, 100.0f, 200.0f, Color.red);
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GradientPaint gp1 = p1;
        GradientPaint gp2 = (GradientPaint)p2;
        SerialUtilitiesTests.assertEquals(gp1.getColor1(), gp2.getColor1());
        SerialUtilitiesTests.assertEquals(gp1.getPoint1(), gp2.getPoint1());
        SerialUtilitiesTests.assertEquals(gp1.getColor2(), gp2.getColor2());
        SerialUtilitiesTests.assertEquals(gp1.getPoint2(), gp2.getPoint2());
        SerialUtilitiesTests.assertEquals(gp1.isCyclic(), gp2.isCyclic());
    }

    public void testAlphaCompositeSerialization() {
        AlphaComposite c1 = AlphaComposite.getInstance(2, 0.345f);
        Composite c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeComposite(c1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            c2 = SerialUtilities.readComposite(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AlphaComposite ac1 = c1;
        AlphaComposite ac2 = (AlphaComposite)c2;
        SerialUtilitiesTests.assertEquals(ac1.getRule(), ac2.getRule());
        SerialUtilitiesTests.assertEquals(ac1.getAlpha(), ac2.getAlpha(), 0.001f);
    }

    public void testTexturePaintSerialization() {
        TexturePaint p1 = new TexturePaint(new BufferedImage(5, 5, 1), new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0));
        Paint p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writePaint(p1, out);
            out.close();
            ByteArrayInputStream bias = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bias);
            p2 = SerialUtilities.readPaint(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertNull(p2);
    }

    public void testLine2DFloatSerialization() {
        Line2D.Float l1 = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Line2D l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(l1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            l2 = (Line2D)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(l1, l2));
    }

    public void testLine2DDoubleSerialization() {
        Line2D.Double l1 = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        Line2D l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(l1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            l2 = (Line2D)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(l1, l2));
    }

    public void testRectangle2DFloatSerialization() {
        Rectangle2D.Float r1 = new Rectangle2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Rectangle2D r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(r1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            r2 = (Rectangle2D)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(r1, r2));
    }

    public void testRectangle2DDoubleSerialization() {
        Rectangle2D.Double r1 = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        Rectangle2D r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(r1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            r2 = (Rectangle2D)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(r1, r2));
    }

    public void testArc2DFloatSerialization() {
        Arc2D.Float a1 = new Arc2D.Float(1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 2);
        Arc2D a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(a1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            a2 = (Arc2D)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(a1, a2));
    }

    public void testArc2DDoubleSerialization() {
        Arc2D.Double a1 = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        Arc2D a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(a1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            a2 = (Arc2D)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(a1, a2));
    }

    public void testGeneralPathSerialization() {
        GeneralPath g1 = new GeneralPath();
        g1.moveTo(1.0f, 2.0f);
        g1.lineTo(3.0f, 4.0f);
        g1.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        g1.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        g1.closePath();
        GeneralPath g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeShape(g1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            g2 = (GeneralPath)SerialUtilities.readShape(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(ShapeUtilities.equal(g1, g2));
    }

    public void testAttributedStringSerialization1() {
        AttributedString s1 = new AttributedString("");
        AttributedString s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeAttributedString(s1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            s2 = SerialUtilities.readAttributedString(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(AttributedStringUtilities.equal(s1, s2));
    }

    public void testAttributedStringSerialization2() {
        AttributedString s1 = new AttributedString("ABC");
        AttributedString s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeAttributedString(s1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            s2 = SerialUtilities.readAttributedString(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(AttributedStringUtilities.equal(s1, s2));
    }

    public void testAttributedStringSerialization3() {
        AttributedString s1 = new AttributedString("ABC");
        s1.addAttribute(TextAttribute.LANGUAGE, "English");
        AttributedString s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            SerialUtilities.writeAttributedString(s1, out);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            s2 = SerialUtilities.readAttributedString(in);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SerialUtilitiesTests.assertTrue(AttributedStringUtilities.equal(s1, s2));
    }
}

