/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public class RectangleInsetsTests
extends TestCase {
    private static final double EPSILON = 1.0E-7;

    public static Test suite() {
        return new TestSuite((Class<?>)RectangleInsetsTests.class);
    }

    public RectangleInsetsTests(String name) {
        super(name);
    }

    public void testCreateAdjustedRectangleAbsolute() {
        RectangleInsets i1 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        Rectangle2D.Double base = new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0);
        Rectangle2D adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(10.0, 19.0, 30.0, 44.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(10.0, 21.0, 30.0, 36.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.EXPAND, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(8.0, 20.0, 36.0, 40.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(12.0, 20.0, 24.0, 40.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.EXPAND, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(8.0, 19.0, 36.0, 44.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.EXPAND, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(8.0, 21.0, 36.0, 36.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(12.0, 21.0, 24.0, 36.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(12.0, 19.0, 24.0, 44.0), adjusted);
    }

    public void testCreateAdjustedRectangleRelative() {
        RectangleInsets i1 = new RectangleInsets(UnitType.RELATIVE, 0.04, 0.03, 0.02, 0.01);
        Rectangle2D.Double base = new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0);
        Rectangle2D adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals(new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0), adjusted);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals(10.0, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(18.2978723404, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(30.0, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(42.553191489, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals(10.0, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(21.6, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(30.0, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(37.6, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.EXPAND, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals(9.0625, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(20.0, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(31.25, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(40.0, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals(10.9, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(20.0, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(28.8, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(40.0, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.EXPAND, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals(9.0625, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(18.2978723404, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(31.25, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(42.553191489, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.EXPAND, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals(9.0625, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(21.6, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(31.25, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(37.6, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals(10.9, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(21.6, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(28.8, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(37.6, adjusted.getHeight(), 1.0E-7);
        adjusted = i1.createAdjustedRectangle(base, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals(10.9, adjusted.getX(), 1.0E-7);
        RectangleInsetsTests.assertEquals(18.2978723404, adjusted.getY(), 1.0E-7);
        RectangleInsetsTests.assertEquals(28.8, adjusted.getWidth(), 1.0E-7);
        RectangleInsetsTests.assertEquals(42.553191489, adjusted.getHeight(), 1.0E-7);
    }

    public void testEquals() {
        RectangleInsets i1 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsets i2 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue(i1.equals(i2));
        RectangleInsetsTests.assertTrue(i2.equals(i1));
        i1 = new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertFalse(i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue(i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertFalse(i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue(i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 3.0, 4.0);
        RectangleInsetsTests.assertFalse(i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue(i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 4.0);
        RectangleInsetsTests.assertFalse(i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 4.0);
        RectangleInsetsTests.assertTrue(i1.equals(i2));
        i1 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 0.0);
        RectangleInsetsTests.assertFalse(i1.equals(i2));
        i2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 0.0);
        RectangleInsetsTests.assertTrue(i1.equals(i2));
    }

    public void testSerialization() {
        RectangleInsets i1 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsets i2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(i1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            i2 = (RectangleInsets)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        RectangleInsetsTests.assertTrue(i1.equals(i2));
    }

    public static void main(String[] args) {
        TestRunner.run(RectangleInsetsTests.suite());
    }
}

