/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.tabbedui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class VerticalLayout
implements LayoutManager {
    private final boolean useSizeFromParent;

    public VerticalLayout() {
        this(true);
    }

    public VerticalLayout(boolean useParent) {
        this.useSizeFromParent = useParent;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets ins = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = ins.top + ins.bottom;
            int width = ins.left + ins.right;
            int i2 = 0;
            while (i2 < comps.length) {
                if (comps[i2].isVisible()) {
                    Dimension pref = comps[i2].getPreferredSize();
                    height += pref.height;
                    if (pref.width > width) {
                        width = pref.width;
                    }
                }
                ++i2;
            }
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets ins = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = ins.top + ins.bottom;
            int width = ins.left + ins.right;
            int i2 = 0;
            while (i2 < comps.length) {
                if (comps[i2].isVisible()) {
                    Dimension min = comps[i2].getMinimumSize();
                    height += min.height;
                    if (min.width > width) {
                        width = min.width;
                    }
                }
                ++i2;
            }
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }
    }

    public boolean isUseSizeFromParent() {
        return this.useSizeFromParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width;
            Insets ins = parent.getInsets();
            int insHorizontal = ins.left + ins.right;
            if (this.isUseSizeFromParent()) {
                Rectangle bounds = parent.getBounds();
                width = bounds.width - insHorizontal;
            } else {
                width = this.preferredLayoutSize((Container)parent).width - insHorizontal;
            }
            Component[] comps = parent.getComponents();
            int y = ins.top;
            int i2 = 0;
            while (i2 < comps.length) {
                Component c = comps[i2];
                if (c.isVisible()) {
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(ins.left, y, width, dim.height);
                    y += dim.height;
                }
                ++i2;
            }
        }
    }
}

