/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] array) {
        if (array == null) {
            return null;
        }
        float[][] result = new float[array.length][];
        System.arraycopy(array, 0, result, 0, array.length);
        int i2 = 0;
        while (i2 < array.length) {
            float[] child = array[i2];
            float[] copychild = new float[child.length];
            System.arraycopy(child, 0, copychild, 0, child.length);
            result[i2] = copychild;
            ++i2;
        }
        return result;
    }

    public static boolean equalReferencesInArrays(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < array1.length) {
            if (array1[i2] == null && array2[i2] != null) {
                return false;
            }
            if (array2[i2] == null && array1[i2] != null) {
                return false;
            }
            if (array1[i2] != array2[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean equal(float[][] array1, float[][] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < array1.length) {
            if (!Arrays.equals(array1[i2], array2[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] array) {
        int i2 = 0;
        while (i2 < array.length) {
            int j = 0;
            while (j < i2) {
                Object o1 = array[i2];
                Object o2 = array[j];
                if (o1 != null && o2 != null && o1.equals(o2)) {
                    return true;
                }
                ++j;
            }
            ++i2;
        }
        return false;
    }

    public static int compareVersionArrays(Comparable[] a1, Comparable[] a2) {
        int length = Math.min(a1.length, a2.length);
        int i2 = 0;
        while (i2 < length) {
            Comparable o1 = a1[i2];
            Comparable o2 = a2[i2];
            if (o1 != null || o2 != null) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int retval = o1.compareTo(o2);
                if (retval != 0) {
                    return retval;
                }
            }
            ++i2;
        }
        return 0;
    }
}

