/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.io.SerialUtilities;
import org.jfree.util.AbstractObjectList;
import org.jfree.util.ShapeUtilities;

public class ShapeList
extends AbstractObjectList {
    public Shape getShape(int index) {
        return (Shape)this.get(index);
    }

    public void setShape(int index, Shape shape) {
        this.set(index, shape);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShapeList)) {
            return false;
        }
        ShapeList that = (ShapeList)obj;
        int listSize = this.size();
        int i2 = 0;
        while (i2 < listSize) {
            if (!ShapeUtilities.equal((Shape)this.get(i2), (Shape)that.get(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int count = this.size();
        stream.writeInt(count);
        int i2 = 0;
        while (i2 < count) {
            Shape shape = this.getShape(i2);
            if (shape != null) {
                stream.writeInt(i2);
                SerialUtilities.writeShape(shape, stream);
            } else {
                stream.writeInt(-1);
            }
            ++i2;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int count = stream.readInt();
        int i2 = 0;
        while (i2 < count) {
            int index = stream.readInt();
            if (index != -1) {
                this.setShape(index, SerialUtilities.readShape(stream));
            }
            ++i2;
        }
    }
}

