/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ArrayUtilities;

public class ArrayUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)ArrayUtilitiesTests.class);
    }

    public ArrayUtilitiesTests(String name) {
        super(name);
    }

    public void testHasDuplicateItems() {
        Object[] a1 = new Object[]{"1", "2", "3"};
        Object[] a2 = new Object[]{"1", "1", "3"};
        Object[] objectArray = new Object[3];
        objectArray[1] = "2";
        Object[] a3 = objectArray;
        ArrayUtilitiesTests.assertFalse(ArrayUtilities.hasDuplicateItems(a1));
        ArrayUtilitiesTests.assertTrue(ArrayUtilities.hasDuplicateItems(a2));
        ArrayUtilitiesTests.assertFalse(ArrayUtilities.hasDuplicateItems(a3));
    }

    public void testEqualReferencesInArrays() {
        Object[] a1 = new Object[]{};
        Object[] a2 = new Object[]{};
        Object[] a3 = new Object[1];
        Object[] a4 = new Object[1];
        Object[] a5 = new Object[]{"A"};
        Object[] a6 = new Object[]{"A"};
        Object[] a7 = new Object[]{"A", "B"};
        Object[] a8 = new Object[]{"A", "B"};
        Object[] objectArray = new Object[2];
        objectArray[0] = "A";
        Object[] a9 = objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "A";
        Object[] a10 = objectArray2;
        ArrayUtilitiesTests.assertTrue(ArrayUtilities.equalReferencesInArrays(a1, a2));
        ArrayUtilitiesTests.assertFalse(ArrayUtilities.equalReferencesInArrays(a1, a3));
        ArrayUtilitiesTests.assertTrue(ArrayUtilities.equalReferencesInArrays(a3, a4));
        ArrayUtilitiesTests.assertFalse(ArrayUtilities.equalReferencesInArrays(a3, a5));
        ArrayUtilitiesTests.assertTrue(ArrayUtilities.equalReferencesInArrays(a5, a6));
        ArrayUtilitiesTests.assertFalse(ArrayUtilities.equalReferencesInArrays(a5, a7));
        ArrayUtilitiesTests.assertTrue(ArrayUtilities.equalReferencesInArrays(a7, a8));
        ArrayUtilitiesTests.assertFalse(ArrayUtilities.equalReferencesInArrays(a7, a9));
        ArrayUtilitiesTests.assertTrue(ArrayUtilities.equalReferencesInArrays(a9, a10));
    }
}

