/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ObjectList;

public class ObjectListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)ObjectListTests.class);
    }

    public ObjectListTests(String name) {
        super(name);
    }

    public void testEquals() {
        ObjectList l1 = new ObjectList();
        l1.set(0, Color.blue);
        l1.set(1, Color.red);
        ObjectList l2 = new ObjectList();
        l2.set(0, Color.blue);
        l2.set(1, Color.red);
        ObjectListTests.assertTrue(l1.equals(l2));
        ObjectListTests.assertTrue(l2.equals(l2));
    }

    public void testEquals2() {
        ObjectList l1 = new ObjectList(20);
        l1.set(0, Color.blue);
        l1.set(1, Color.red);
        ObjectList l2 = new ObjectList();
        l2.set(0, Color.blue);
        l2.set(1, Color.red);
        ObjectListTests.assertTrue(l1.equals(l2));
        ObjectListTests.assertTrue(l2.equals(l2));
    }

    public void testCloning() {
        ObjectList l1 = new ObjectList();
        l1.set(0, Color.blue);
        l1.set(1, Color.red);
        ObjectList l2 = null;
        try {
            l2 = (ObjectList)l1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("ObjectListTests.testCloning: failed to clone.");
        }
        ObjectListTests.assertTrue(l1 != l2);
        ObjectListTests.assertTrue(l1.getClass() == l2.getClass());
        ObjectListTests.assertTrue(l1.equals(l2));
        l2.set(0, Color.green);
        ObjectListTests.assertFalse(l1.equals(l2));
    }

    public void testSerialization() {
        ObjectList l1 = new ObjectList();
        l1.set(0, Color.red);
        l1.set(1, Color.blue);
        l1.set(2, null);
        ObjectList l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (ObjectList)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        ObjectListTests.assertEquals(l1, l2);
    }

    public void testExpand() {
        ObjectList l1 = new ObjectList();
        l1.set(10, Color.blue);
        Color c = (Color)l1.get(10);
        ObjectListTests.assertTrue(c.equals(Color.blue));
    }
}

