/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ObjectUtilities;

public class ObjectUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)ObjectUtilitiesTests.class);
    }

    public ObjectUtilitiesTests(String name) {
        super(name);
    }

    public void testCloneObject() throws CloneNotSupportedException {
        Object clone;
        boolean pass = false;
        Object obj = "Hello World";
        try {
            clone = ObjectUtilities.clone(obj);
            pass = false;
        }
        catch (CloneNotSupportedException e) {
            pass = true;
        }
        ObjectUtilitiesTests.assertTrue(pass);
        pass = false;
        obj = new Integer(123);
        try {
            clone = ObjectUtilities.clone(obj);
            pass = false;
        }
        catch (CloneNotSupportedException e) {
            pass = true;
        }
        ObjectUtilitiesTests.assertTrue(pass);
        obj = new Point(1, 2);
        clone = ObjectUtilities.clone(obj);
        ObjectUtilitiesTests.assertEquals(obj, clone);
        obj = null;
        try {
            clone = ObjectUtilities.clone(obj);
            pass = false;
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        ObjectUtilitiesTests.assertTrue(pass);
    }

    public void testDeepClone() {
        ArrayList<Object> c1 = new ArrayList<Object>();
        Collection c2 = null;
        try {
            c2 = ObjectUtilities.deepClone(c1);
            ObjectUtilitiesTests.assertTrue(c2.isEmpty());
        }
        catch (CloneNotSupportedException e) {
            ObjectUtilitiesTests.assertTrue(false);
        }
        c1 = new ArrayList();
        c1.add(new Point(1, 2));
        c1.add(new Point(3, 4));
        try {
            c2 = ObjectUtilities.deepClone(c1);
            ObjectUtilitiesTests.assertEquals(2, c2.size());
            ObjectUtilitiesTests.assertTrue(c2.contains(new Point(1, 2)));
            ObjectUtilitiesTests.assertTrue(c2.contains(new Point(3, 4)));
        }
        catch (CloneNotSupportedException e) {
            ObjectUtilitiesTests.assertTrue(false);
        }
        c1 = new ArrayList();
        c1.add(new Point(1, 2));
        c1.add(null);
        c1.add(new Point(3, 4));
        try {
            c2 = ObjectUtilities.deepClone(c1);
            ObjectUtilitiesTests.assertEquals(3, c2.size());
            ObjectUtilitiesTests.assertTrue(c2.contains(new Point(1, 2)));
            ObjectUtilitiesTests.assertTrue(c2.contains(new Point(3, 4)));
        }
        catch (CloneNotSupportedException e) {
            ObjectUtilitiesTests.assertTrue(false);
        }
        c1.clear();
        c1.add("S1");
        c1.add("S2");
        try {
            c2 = ObjectUtilities.deepClone(c1);
            ObjectUtilitiesTests.assertTrue(false);
        }
        catch (CloneNotSupportedException e) {
            ObjectUtilitiesTests.assertTrue(true);
        }
        try {
            c2 = ObjectUtilities.deepClone(null);
            ObjectUtilitiesTests.assertTrue(false);
        }
        catch (IllegalArgumentException e) {
            ObjectUtilitiesTests.assertTrue(true);
        }
        catch (CloneNotSupportedException e) {
            ObjectUtilitiesTests.assertTrue(false);
        }
    }
}

