/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Color;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.PaintList;

public class PaintListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)PaintListTests.class);
    }

    public PaintListTests(String name) {
        super(name);
    }

    public void testEquals() {
        PaintList l1 = new PaintList();
        l1.setPaint(0, Color.red);
        l1.setPaint(1, Color.blue);
        l1.setPaint(2, null);
        PaintList l2 = new PaintList();
        l2.setPaint(0, Color.red);
        l2.setPaint(1, Color.blue);
        l2.setPaint(2, null);
        PaintListTests.assertTrue(l1.equals(l2));
        PaintListTests.assertTrue(l2.equals(l2));
    }

    public void testEquals2() {
        PaintList l1 = new PaintList();
        Color color1 = new Color(200, 200, 200);
        l1.setPaint(0, color1);
        PaintList l2 = new PaintList();
        Color color2 = new Color(200, 200, 200);
        l2.setPaint(0, color2);
        PaintListTests.assertEquals(l1, l2);
    }

    public void testEquals3() {
        PaintList l1 = new PaintList();
        GradientPaint p1 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.blue);
        l1.setPaint(0, p1);
        PaintList l2 = new PaintList();
        GradientPaint p2 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.blue);
        l2.setPaint(0, p2);
        PaintListTests.assertEquals(l1, l2);
    }

    public void testCloning() {
        PaintList l1 = new PaintList();
        l1.setPaint(0, Color.red);
        l1.setPaint(1, Color.blue);
        l1.setPaint(2, null);
        PaintList l2 = null;
        try {
            l2 = (PaintList)l1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("PaintListTests.testCloning: failed to clone.");
        }
        PaintListTests.assertTrue(l1 != l2);
        PaintListTests.assertTrue(l1.getClass() == l2.getClass());
        PaintListTests.assertTrue(l1.equals(l2));
        l2.setPaint(0, Color.green);
        PaintListTests.assertFalse(l1.equals(l2));
    }

    public void testSerialization() {
        PaintList l1 = new PaintList();
        l1.setPaint(0, Color.red);
        l1.setPaint(1, Color.blue);
        l1.setPaint(2, null);
        PaintList l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (PaintList)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        PaintListTests.assertEquals(l1, l2);
    }
}

