/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ShapeList;

public class ShapeListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite((Class<?>)ShapeListTests.class);
    }

    public ShapeListTests(String name) {
        super(name);
    }

    public void testEquals() {
        ShapeList l1 = new ShapeList();
        l1.setShape(0, new Rectangle(1, 2, 3, 4));
        l1.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        l1.setShape(2, null);
        ShapeList l2 = new ShapeList();
        l2.setShape(0, new Rectangle(1, 2, 3, 4));
        l2.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        l2.setShape(2, null);
        ShapeListTests.assertTrue(l1.equals(l2));
        ShapeListTests.assertTrue(l2.equals(l2));
    }

    public void testCloning() {
        ShapeList l1 = new ShapeList();
        l1.setShape(0, new Rectangle(1, 2, 3, 4));
        l1.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        l1.setShape(2, null);
        ShapeList l2 = null;
        try {
            l2 = (ShapeList)l1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        ShapeListTests.assertTrue(l1 != l2);
        ShapeListTests.assertTrue(l1.getClass() == l2.getClass());
        ShapeListTests.assertTrue(l1.equals(l2));
        l2.setShape(0, new Rectangle(5, 6, 7, 8));
        ShapeListTests.assertFalse(l1.equals(l2));
    }

    public void testSerialization() {
        ShapeList l1 = new ShapeList();
        l1.setShape(0, new Rectangle(1, 2, 3, 4));
        l1.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        l1.setShape(2, null);
        ShapeList l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (ShapeList)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ShapeListTests.assertEquals(l1, l2);
    }
}

