/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ParseException
extends SAXException {
    private int line;
    private int column;

    public ParseException(String message) {
        super(message);
        this.fillLocation(null);
    }

    public ParseException(Exception e) {
        super(e);
        this.fillLocation(null);
    }

    public ParseException(String s, Exception e) {
        super(s, e);
        this.fillLocation(null);
    }

    public ParseException(String message, Locator locator) {
        super(message);
        this.fillLocation(locator);
    }

    public ParseException(Exception e, Locator locator) {
        super(e);
        this.fillLocation(locator);
    }

    public ParseException(String s, Exception e, Locator locator) {
        super(s, e);
        this.fillLocation(locator);
    }

    @Override
    public String getMessage() {
        StringBuffer message = new StringBuffer(String.valueOf(super.getMessage()));
        message.append(" [Location: Line=");
        message.append(this.line);
        message.append(" Column=");
        message.append(this.column);
        message.append("] ");
        return message.toString();
    }

    protected void fillLocation(Locator locator) {
        if (locator == null) {
            this.line = -1;
            this.column = -1;
        } else {
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.getException() != null) {
            stream.println("ParentException: ");
            this.getException().printStackTrace(stream);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getMessage();
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.getException() != null) {
            writer.println("ParentException: ");
            this.getException().printStackTrace(writer);
        }
    }
}

