/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.util.HashMap;
import java.util.Stack;
import org.jfree.xml.ElementDefinitionHandler;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Parser
extends FrontendDefaultHandler {
    public static final String CONTENTBASE_KEY = "content-base";
    private Stack activeFactories = new Stack();
    private ElementDefinitionHandler initialFactory;
    private HashMap parserHelperObjects = new HashMap();

    public String[] getComments() {
        return this.getCommentHandler().getComments();
    }

    public void pushFactory(ElementDefinitionHandler factory) {
        this.activeFactories.push(factory);
    }

    public ElementDefinitionHandler peekFactory() {
        return (ElementDefinitionHandler)this.activeFactories.peek();
    }

    public ElementDefinitionHandler popFactory() {
        this.activeFactories.pop();
        return this.peekFactory();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.activeFactories.clear();
        this.pushFactory(this.getInitialFactory());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.peekFactory().characters(ch, start, length);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException(e, this.getLocator());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            try {
                this.peekFactory().endElement(qName);
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new ParseException(e, this.getLocator());
            }
        }
        finally {
            this.getCommentHandler().clearComments();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            try {
                this.peekFactory().startElement(qName, attributes);
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new ParseException(e, this.getLocator());
            }
        }
        finally {
            this.getCommentHandler().clearComments();
        }
    }

    public void setInitialFactory(ElementDefinitionHandler factory) {
        this.initialFactory = factory;
    }

    public ElementDefinitionHandler getInitialFactory() {
        return this.initialFactory;
    }

    public void setHelperObject(String key, Object value) {
        if (value == null) {
            this.parserHelperObjects.remove(key);
        } else {
            this.parserHelperObjects.put(key, value);
        }
    }

    public Object getHelperObject(String key) {
        return this.parserHelperObjects.get(key);
    }

    public abstract Parser getInstance();

    @Override
    public final FrontendDefaultHandler newInstance() {
        return this.getInstance();
    }

    @Override
    public abstract Object getResult();
}

