/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ClassFactoryImpl;
import org.jfree.xml.factory.objects.ObjectDescription;

public class ClassFactoryCollector
extends ClassFactoryImpl {
    private ArrayList factories = new ArrayList();

    public void addFactory(ClassFactory factory) {
        this.factories.add(factory);
        if (this.getConfig() != null) {
            factory.configure(this.getConfig());
        }
    }

    public Iterator getFactories() {
        return this.factories.iterator();
    }

    @Override
    public ObjectDescription getDescriptionForClass(Class c) {
        int i2 = 0;
        while (i2 < this.factories.size()) {
            ClassFactory f = (ClassFactory)this.factories.get(i2);
            ObjectDescription od = f.getDescriptionForClass(c);
            if (od != null) {
                return od;
            }
            ++i2;
        }
        return super.getDescriptionForClass(c);
    }

    @Override
    public ObjectDescription getSuperClassObjectDescription(Class d, ObjectDescription knownSuperClass) {
        int i2 = 0;
        while (i2 < this.factories.size()) {
            ClassFactory f = (ClassFactory)this.factories.get(i2);
            ObjectDescription od = f.getSuperClassObjectDescription(d, knownSuperClass);
            if (od != null) {
                if (knownSuperClass == null) {
                    knownSuperClass = od;
                } else if (this.getComparator().isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) && this.getComparator().compare(knownSuperClass.getObjectClass(), od.getObjectClass()) < 0) {
                    knownSuperClass = od;
                }
            }
            ++i2;
        }
        return super.getSuperClassObjectDescription(d, knownSuperClass);
    }

    @Override
    public Iterator getRegisteredClasses() {
        ArrayList list = new ArrayList();
        int i2 = 0;
        while (i2 < this.factories.size()) {
            ClassFactory f = (ClassFactory)this.factories.get(i2);
            Iterator iterator = f.getRegisteredClasses();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            ++i2;
        }
        return list.iterator();
    }

    @Override
    public void configure(Configuration config) {
        if (this.getConfig() != null) {
            return;
        }
        super.configure(config);
        for (ClassFactory od : this.factories) {
            od.configure(config);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassFactoryCollector)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassFactoryCollector classFactoryCollector = (ClassFactoryCollector)o;
        return this.factories.equals(classFactoryCollector.factories);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.factories.hashCode();
        return result;
    }
}

