/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jfree.io.IOUtils;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MappingModel;
import org.jfree.xml.generator.model.MultiplexMappingInfo;

public class SplittingModelWriter
extends ModelWriter {
    private HashNMap classDescriptionByPackage;
    private ArrayList sources;
    private File targetFile;
    private String extension;
    private String plainFileName;
    private HashNMap manualMappingByPackage;
    private HashNMap multiplexMappingByPackage;

    public synchronized void write(String target) throws IOException {
        DescriptionModel model = this.getModel();
        this.sources = new ArrayList<String>(Arrays.asList(model.getSources()));
        this.targetFile = new File(target);
        this.plainFileName = IOUtils.getInstance().stripFileExtension(this.targetFile.getName());
        this.extension = IOUtils.getInstance().getFileExtension(target);
        this.classDescriptionByPackage = new HashNMap();
        int i2 = 0;
        while (i2 < model.size()) {
            ClassDescription cd = model.get(i2);
            if (cd.getSource() == null) {
                String packageName = SplittingModelWriter.getPackage(cd.getObjectClass());
                String includeFileName = String.valueOf(this.plainFileName) + "-" + packageName + this.extension;
                this.classDescriptionByPackage.add(includeFileName, cd);
            } else {
                this.classDescriptionByPackage.add(cd.getSource(), cd);
            }
            ++i2;
        }
        MappingModel mappingModel = model.getMappingModel();
        ManualMappingInfo[] manualMappings = mappingModel.getManualMapping();
        this.manualMappingByPackage = new HashNMap();
        int i3 = 0;
        while (i3 < manualMappings.length) {
            ManualMappingInfo mapping = manualMappings[i3];
            if (mapping.getSource() == null) {
                this.manualMappingByPackage.add("", mapping);
            } else {
                this.manualMappingByPackage.add(mapping.getSource(), mapping);
            }
            ++i3;
        }
        MultiplexMappingInfo[] multiplexMappings = mappingModel.getMultiplexMapping();
        this.multiplexMappingByPackage = new HashNMap();
        int i4 = 0;
        while (i4 < multiplexMappings.length) {
            MultiplexMappingInfo mapping = multiplexMappings[i4];
            if (mapping.getSource() == null) {
                this.multiplexMappingByPackage.add("", mapping);
            } else {
                this.multiplexMappingByPackage.add(mapping.getSource(), mapping);
            }
            ++i4;
        }
        Object[] keys = this.classDescriptionByPackage.keySet().toArray();
        int i5 = 0;
        while (i5 < keys.length) {
            String includeFileName = (String)keys[i5];
            if (!includeFileName.equals("")) {
                this.writePackageFile(includeFileName);
            }
            ++i5;
        }
        this.writeMasterFile();
        this.manualMappingByPackage = null;
        this.multiplexMappingByPackage = null;
        this.classDescriptionByPackage = null;
        this.sources = null;
    }

    private void writePackageFile(String includeFileName) throws IOException {
        Object mi;
        Iterator values = this.classDescriptionByPackage.getAll(includeFileName);
        Iterator manualMappings = this.manualMappingByPackage.getAll(includeFileName);
        Iterator multiplexMappings = this.multiplexMappingByPackage.getAll(includeFileName);
        if (!(values.hasNext() || manualMappings.hasNext() || multiplexMappings.hasNext())) {
            return;
        }
        Log.debug("Writing included file: " + includeFileName);
        this.sources.remove(includeFileName);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.targetFile.getParentFile(), includeFileName)), "UTF-8"));
        SplittingModelWriter.writeXMLHeader(writer);
        this.writeStandardComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeTag(writer, "objects");
        while (values.hasNext()) {
            ClassDescription cd = (ClassDescription)values.next();
            this.writeClassDescription(writer, cd);
        }
        while (manualMappings.hasNext()) {
            mi = (ManualMappingInfo)manualMappings.next();
            this.writeManualMapping(writer, (ManualMappingInfo)mi);
        }
        while (multiplexMappings.hasNext()) {
            mi = (MultiplexMappingInfo)multiplexMappings.next();
            this.writeMultiplexMapping(writer, (MultiplexMappingInfo)mi);
        }
        this.writeCloseComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeCloseTag(writer, "objects");
        writer.close();
    }

    public static String getPackage(Class c) {
        String className = c.getName();
        int idx = className.lastIndexOf(46);
        if (idx <= 0) {
            return "";
        }
        return className.substring(0, idx);
    }

    private void writeMasterFile() throws IOException {
        Log.debug("Writing master file: " + this.targetFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.targetFile), "UTF-8"));
        SplittingModelWriter.writeXMLHeader(writer);
        this.writeStandardComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeTag(writer, "objects");
        int i2 = 0;
        while (i2 < this.sources.size()) {
            String includeFileName = (String)this.sources.get(i2);
            if (!includeFileName.equals("")) {
                this.writeTag(writer, "include", "src", includeFileName, this.getModel().getIncludeComment(includeFileName));
            }
            ++i2;
        }
        Object[] keys = this.classDescriptionByPackage.keySet().toArray();
        Arrays.sort(keys);
        int i3 = 0;
        while (i3 < keys.length) {
            String includeFileName = (String)keys[i3];
            if (!includeFileName.equals("")) {
                this.writeTag(writer, "include", "src", includeFileName, this.getModel().getIncludeComment(includeFileName));
            }
            ++i3;
        }
        Iterator values = this.classDescriptionByPackage.getAll("");
        while (values.hasNext()) {
            ClassDescription cd = (ClassDescription)values.next();
            this.writeClassDescription(writer, cd);
        }
        Iterator manualMappings = this.manualMappingByPackage.getAll("");
        while (manualMappings.hasNext()) {
            ManualMappingInfo mi = (ManualMappingInfo)manualMappings.next();
            this.writeManualMapping(writer, mi);
        }
        Iterator multiplexMappings = this.multiplexMappingByPackage.getAll("");
        while (multiplexMappings.hasNext()) {
            MultiplexMappingInfo mi = (MultiplexMappingInfo)multiplexMappings.next();
            this.writeMultiplexMapping(writer, mi);
        }
        this.writeCloseComment(writer, this.getModel().getModelComments());
        this.getWriterSupport().writeCloseTag(writer, "objects");
        writer.close();
    }
}

