/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class PrintBeanInfo {
    private PrintBeanInfo() {
    }

    public static void print(Class c) {
        try {
            System.out.println("Class: " + c.getName());
            System.out.println("========================================================================");
            BeanInfo bi = Introspector.getBeanInfo(c, c.getSuperclass());
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            int i2 = 0;
            while (i2 < pd.length) {
                System.out.println("Property: " + pd[i2].getDisplayName());
                System.out.println("---------------------------------------------------------------------");
                System.out.println(" ( " + pd[i2].getShortDescription() + ")");
                if (pd[i2] instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)pd[i2];
                    System.out.println("  - idx-type   : " + id.getIndexedPropertyType());
                    System.out.println("  - idx-read   : " + id.getIndexedReadMethod());
                    System.out.println("  - idx-write  : " + id.getIndexedWriteMethod());
                } else {
                    System.out.println("  - type       : " + pd[i2].getPropertyType());
                    System.out.println("  - read       : " + pd[i2].getReadMethod());
                    System.out.println("  - write      : " + pd[i2].getWriteMethod());
                }
                System.out.println("  - bound      : " + pd[i2].isBound());
                System.out.println("  - constrained: " + pd[i2].isConstrained());
                ++i2;
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        int i2 = 0;
        while (i2 < args.length) {
            PrintBeanInfo.print(Class.forName(args[i2]));
            ++i2;
        }
    }
}

