/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser.coretypes;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.ObjectRefHandler;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GenericReadHandler
extends AbstractXmlReadHandler {
    private Object object;
    private GenericObjectFactory objectFactory;
    private ArrayList objectRefHandlers;
    private HashMap createdHandler = new HashMap();

    public GenericReadHandler(GenericObjectFactory factory) {
        this.objectRefHandlers = new ArrayList();
        this.objectFactory = factory;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        try {
            AttributeDefinition[] attribs = this.objectFactory.getAttributeDefinitions();
            int i2 = 0;
            while (i2 < attribs.length) {
                AttributeDefinition attrDef = attribs[i2];
                String value = attrs.getValue(attrDef.getAttributeName());
                if (value != null) {
                    Object o = attrDef.getHandler().toPropertyValue(value);
                    this.objectFactory.setProperty(attrDef.getPropertyName(), o);
                }
                ++i2;
            }
        }
        catch (ObjectDescriptionException ode) {
            throw new SAXException(ode);
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String tagName, Attributes atts) throws SAXException {
        try {
            if (tagName.equals("objectRef")) {
                ObjectRefHandler handler = new ObjectRefHandler();
                this.objectRefHandlers.add(handler);
                return handler;
            }
            XmlReadHandler handler = this.getRootHandler().createHandler(this.objectFactory.getTypeForTagName(tagName), tagName, atts);
            if (handler != null) {
                this.createdHandler.put(tagName, handler);
            }
            return handler;
        }
        catch (ObjectDescriptionException ode) {
            Log.debug("Failed to get handler for child: ", ode);
            throw new SAXException(ode);
        }
    }

    @Override
    public Object getObject() throws XmlReaderException {
        if (this.object != null) {
            return this.object;
        }
        RootXmlReadHandler rootHandler = this.getRootHandler();
        try {
            int i2 = 0;
            while (i2 < this.objectRefHandlers.size()) {
                ObjectRefHandler handler = (ObjectRefHandler)this.objectRefHandlers.get(i2);
                this.objectFactory.setProperty(handler.getPropertyName(), handler.getObject());
                ++i2;
            }
            ArrayList<String> lookups = new ArrayList<String>();
            LookupDefinition[] lookupDefs = this.objectFactory.getLookupDefinitions();
            int i3 = 0;
            while (i3 < lookupDefs.length) {
                LookupDefinition ldef = lookupDefs[i3];
                lookups.add(ldef.getPropertyName());
                Log.debug("lookup object: " + ldef.getPropertyName());
                Object value = rootHandler.getHelperObject(ldef.getRegistryKey());
                if (value == null) {
                    Log.warn("Failed to lookup object: " + value);
                } else {
                    this.objectFactory.setProperty(ldef.getPropertyName(), value);
                }
                ++i3;
            }
            ConstructorDefinition[] conDefs = this.objectFactory.getConstructorDefinitions();
            int i4 = 0;
            while (i4 < conDefs.length) {
                PropertyDefinition pd;
                XmlReadHandler handler;
                ConstructorDefinition cDef = conDefs[i4];
                if (!lookups.contains(cDef.getPropertyName()) && this.objectFactory.isPropertyDefinition(cDef.getPropertyName()) && (handler = (XmlReadHandler)this.createdHandler.get((pd = this.objectFactory.getPropertyDefinitionByPropertyName(cDef.getPropertyName())).getElementName())) != null) {
                    this.objectFactory.setProperty(pd.getPropertyName(), handler.getObject());
                }
                ++i4;
            }
            this.object = this.objectFactory.createObject();
            Object oldValue = null;
            if (this.objectFactory.getRegisterName() != null) {
                oldValue = rootHandler.getHelperObject(this.objectFactory.getRegisterName());
                rootHandler.setHelperObject(this.objectFactory.getRegisterName(), this.object);
            }
            PropertyDefinition[] propertyDefs = this.objectFactory.getPropertyDefinitions();
            int i5 = 0;
            while (i5 < propertyDefs.length) {
                PropertyDefinition pdef = propertyDefs[i5];
                XmlReadHandler handler = (XmlReadHandler)this.createdHandler.get(pdef.getElementName());
                if (handler != null) {
                    this.objectFactory.setProperty(pdef.getPropertyName(), handler.getObject());
                }
                ++i5;
            }
            this.objectFactory.writeObjectProperties(this.object);
            if (this.objectFactory.getRegisterName() != null) {
                rootHandler.setHelperObject(this.objectFactory.getRegisterName(), oldValue);
            }
        }
        catch (ObjectDescriptionException ode) {
            Log.error("Unable to create object.", ode);
            throw new XmlReaderException("Unable to create object.", ode);
        }
        return this.object;
    }
}

