/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.awt.RenderingHints;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jfree.util.Log;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;

public class RenderingHintsWriteHandler
extends AbstractXmlWriteHandler {
    @Override
    public void write(String tagName, Object object, XMLWriter writer, String mPlexAttribute, String mPlexValue) throws IOException, XMLWriterException {
        writer.writeTag(tagName, mPlexAttribute, mPlexValue, false);
        writer.allowLineBreak();
        RenderingHints hints = (RenderingHints)object;
        for (RenderingHints.Key key : hints.keySet()) {
            String keyname = this.hintFieldToString(key);
            String value = this.hintFieldToString(hints.get(key));
            AttributeList attribs = new AttributeList();
            attribs.setAttribute("key", keyname);
            attribs.setAttribute("value", value);
            writer.writeTag("entry", attribs, true);
            writer.allowLineBreak();
        }
        writer.writeCloseTag(tagName);
        writer.allowLineBreak();
    }

    private String hintFieldToString(Object o) {
        Field[] fields = RenderingHints.class.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            Field f = fields[i2];
            if (Modifier.isFinal(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers())) {
                try {
                    Object value = f.get(null);
                    if (o.equals(value)) {
                        return f.getName();
                    }
                }
                catch (Exception e) {
                    Log.info("Unable to write RenderingHint", e);
                }
            }
            ++i2;
        }
        throw new IllegalArgumentException("Invalid value given");
    }
}

