/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context context, Class clazz, Callable callable) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        Scriptable scriptable = ScriptRuntime.getTopCallScope(context);
        ClassCache classCache = ClassCache.get(scriptable);
        InterfaceAdapter interfaceAdapter = (InterfaceAdapter)classCache.getInterfaceAdapter(clazz);
        ContextFactory contextFactory = context.getFactory();
        if (interfaceAdapter == null) {
            boolean bl;
            block7: {
                Method[] methodArray = clazz.getMethods();
                if (methodArray.length == 0) {
                    throw Context.reportRuntimeError2("msg.no.empty.interface.conversion", String.valueOf(callable), clazz.getClass().getName());
                }
                bl = false;
                Class<?>[] classArray = methodArray[0].getParameterTypes();
                for (int j = 1; j != methodArray.length; ++j) {
                    Class<?>[] classArray2 = methodArray[j].getParameterTypes();
                    if (classArray2.length != classArray.length) break block7;
                    for (int k = 0; k != classArray.length; ++k) {
                        if (classArray2[k] == classArray[k]) {
                            continue;
                        }
                        break block7;
                    }
                }
                bl = true;
            }
            if (!bl) {
                throw Context.reportRuntimeError2("msg.no.function.interface.conversion", String.valueOf(callable), clazz.getClass().getName());
            }
            interfaceAdapter = new InterfaceAdapter(contextFactory, clazz);
            classCache.cacheInterfaceAdapter(clazz, interfaceAdapter);
        }
        return VMBridge.instance.newInterfaceProxy(interfaceAdapter.proxyHelper, contextFactory, interfaceAdapter, callable, scriptable);
    }

    private InterfaceAdapter(ContextFactory contextFactory, Class clazz) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(contextFactory, new Class[]{clazz});
    }

    public Object invoke(ContextFactory contextFactory, final Object object, final Scriptable scriptable, final Method method, final Object[] objectArray) {
        ContextAction contextAction = new ContextAction(){

            public Object run(Context context) {
                return InterfaceAdapter.this.invokeImpl(context, object, scriptable, method, objectArray);
            }
        };
        return contextFactory.call(contextAction);
    }

    Object invokeImpl(Context context, Object object, Scriptable scriptable, Method method, Object[] objectArray) {
        Object object2;
        int n = objectArray == null ? 0 : objectArray.length;
        Callable callable = (Callable)object;
        Scriptable scriptable2 = scriptable;
        Object[] objectArray2 = new Object[n + 1];
        objectArray2[n] = method.getName();
        if (n != 0) {
            object2 = context.getWrapFactory();
            for (int j = 0; j != n; ++j) {
                objectArray2[j] = ((WrapFactory)object2).wrap(context, scriptable, objectArray[j], null);
            }
        }
        object2 = callable.call(context, scriptable, scriptable2, objectArray2);
        Class<?> clazz = method.getReturnType();
        object2 = clazz == Void.TYPE ? null : Context.jsToJava(object2, clazz);
        return object2;
    }
}

