/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    MemberBox[] ctors;

    JavaMembers(Scriptable scriptable, Class clazz) {
        this.cl = clazz;
        this.reflect(scriptable);
    }

    boolean has(String string, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string);
        if (v != null) {
            return true;
        }
        return null != this.findExplicitFunction(string, bl);
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object3 = hashtable.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        Context context = Context.getContext();
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                if (beanProperty.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                object2 = beanProperty.getter.invoke(object, Context.emptyArgs);
                clazz = beanProperty.getter.method().getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrap(context, scriptable, object2, clazz);
    }

    void put(Scriptable scriptable, String string, Object object, Object object2, boolean bl) {
        Object object3;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object4 = hashtable.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)hashtable.get(string);
            object4 = ((FieldAndMethods)object3).field;
        }
        if (object4 instanceof BeanProperty) {
            object3 = (BeanProperty)object4;
            if (((BeanProperty)object3).setter == null) {
                throw this.reportMemberNotFound(string);
            }
            if (((BeanProperty)object3).setters == null || object2 == null) {
                Class clazz = ((BeanProperty)object3).setter.argTypes[0];
                Object[] objectArray = new Object[]{Context.jsToJava(object2, clazz)};
                try {
                    ((BeanProperty)object3).setter.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw Context.throwAsScriptRuntimeEx(exception);
                }
            } else {
                Object[] objectArray = new Object[]{object2};
                ((BeanProperty)object3).setters.call(Context.getContext(), ScriptableObject.getTopLevelScope(scriptable), scriptable, objectArray);
            }
        } else {
            if (!(object4 instanceof Field)) {
                object3 = object4 == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1((String)object3, string);
            }
            object3 = (Field)object4;
            Object object5 = Context.jsToJava(object2, ((Field)object3).getType());
            try {
                ((Field)object3).set(object, object5);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", object2.getClass().getName(), object3, object.getClass().getName());
            }
        }
    }

    Object[] getIds(boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        int n = hashtable.size();
        Object[] objectArray = new Object[n];
        Enumeration enumeration = hashtable.keys();
        for (int j = 0; j < n; ++j) {
            objectArray[j] = enumeration.nextElement();
        }
        return objectArray;
    }

    static String javaSignature(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        String string = clazz.getName();
        String string2 = "[]";
        if (n == 1) {
            return string.concat(string2);
        }
        int n2 = string.length() + n * string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        while (n != 0) {
            --n;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String liveConnectSignature(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int j = 0; j != n; ++j) {
            if (j != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(JavaMembers.javaSignature(classArray[j]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private MemberBox findExplicitFunction(String string, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        int n = string.indexOf(40);
        if (n < 0) {
            return null;
        }
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        MemberBox[] memberBoxArray = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            memberBoxArray = this.ctors;
        } else {
            String string2 = string.substring(0, n);
            object2 = hashtable.get(string2);
            if (!bl && object2 == null) {
                object2 = this.staticMembers.get(string2);
            }
            if (object2 instanceof NativeJavaMethod) {
                object = (NativeJavaMethod)object2;
                memberBoxArray = ((NativeJavaMethod)object).methods;
            }
        }
        if (memberBoxArray != null) {
            for (int j = 0; j < memberBoxArray.length; ++j) {
                object2 = memberBoxArray[j].argTypes;
                object = JavaMembers.liveConnectSignature(object2);
                if (n + ((String)object).length() != string.length() || !string.regionMatches(n, (String)object, 0, ((String)object).length())) continue;
                return memberBoxArray[j];
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        BaseFunction baseFunction = null;
        MemberBox memberBox = this.findExplicitFunction(string, bl);
        if (memberBox != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (memberBox.isCtor()) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor(memberBox);
                nativeJavaConstructor.setPrototype(scriptable2);
                baseFunction = nativeJavaConstructor;
                hashtable.put(string, nativeJavaConstructor);
            } else {
                String string2 = memberBox.getName();
                baseFunction = (BaseFunction)hashtable.get(string2);
                if (baseFunction instanceof NativeJavaMethod && ((NativeJavaMethod)baseFunction).methods.length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod(memberBox, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    hashtable.put(string, nativeJavaMethod);
                    baseFunction = nativeJavaMethod;
                }
            }
        }
        return baseFunction;
    }

    private static Method[] discoverAccessibleMethods(Class clazz) {
        HashMap hashMap = new HashMap();
        JavaMembers.discoverAccessibleMethods(clazz, hashMap);
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    private static void discoverAccessibleMethods(Class clazz, Map map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methodArray = clazz.getMethods();
                for (int j = 0; j < methodArray.length; ++j) {
                    Method method = methodArray[j];
                    MethodSignature methodSignature = new MethodSignature(method);
                    map.put(methodSignature, method);
                }
                return;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not discover accessible methods of class " + clazz.getName() + " due to lack of privileges, " + "attemping superclasses/interfaces.");
            }
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int j = 0; j < classArray.length; ++j) {
            JavaMembers.discoverAccessibleMethods(classArray[j], map);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            JavaMembers.discoverAccessibleMethods(clazz2, map);
        }
    }

    private void reflect(Scriptable scriptable) {
        int n;
        Hashtable<Object, FieldAndMethods> hashtable;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        int n2;
        Method[] methodArray = JavaMembers.discoverAccessibleMethods(this.cl);
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            Method method = methodArray[n2];
            int n3 = method.getModifiers();
            if (!Modifier.isPublic(n3)) continue;
            boolean bl = Modifier.isStatic(n3);
            object3 = bl ? this.staticMembers : this.members;
            object = ((Hashtable)object3).get(object2 = method.getName());
            if (object == null) {
                ((Hashtable)object3).put(object2, method);
                continue;
            }
            if (object instanceof ObjArray) {
                serializable = (ObjArray)object;
            } else {
                if (!(object instanceof Method)) {
                    Kit.codeBug();
                }
                serializable = new ObjArray();
                serializable.add(object);
                ((Hashtable)object3).put(object2, serializable);
            }
            serializable.add(method);
        }
        for (n2 = 0; n2 != 2; ++n2) {
            boolean bl = n2 == 0;
            Hashtable hashtable2 = bl ? this.staticMembers : this.members;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                object = hashtable2.get(object3);
                if (object instanceof Method) {
                    object2 = new MemberBox[]{new MemberBox((Method)object)};
                } else {
                    serializable = (ObjArray)object;
                    int n4 = serializable.size();
                    if (n4 < 2) {
                        Kit.codeBug();
                    }
                    object2 = new MemberBox[n4];
                    for (int j = 0; j != n4; ++j) {
                        hashtable = (Method)serializable.get(j);
                        object2[j] = new MemberBox((Method)((Object)hashtable));
                    }
                }
                serializable = new NativeJavaMethod((MemberBox[])object2);
                if (scriptable != null) {
                    ScriptRuntime.setFunctionProtoAndParent((BaseFunction)serializable, scriptable);
                }
                hashtable2.put(object3, serializable);
            }
        }
        Field[] fieldArray = this.cl.getFields();
        for (n = 0; n < fieldArray.length; ++n) {
            Object object4;
            Field field = fieldArray[n];
            int n5 = field.getModifiers();
            if (!Modifier.isPublic(n5)) continue;
            boolean bl = Modifier.isStatic(n5);
            object2 = bl ? this.staticMembers : this.members;
            serializable = ((Hashtable)object2).get(object = field.getName());
            if (serializable == null) {
                ((Hashtable)object2).put(object, field);
                continue;
            }
            if (serializable instanceof NativeJavaMethod) {
                object4 = (NativeJavaMethod)serializable;
                FieldAndMethods fieldAndMethods = new FieldAndMethods(scriptable, ((NativeJavaMethod)object4).methods, field);
                Hashtable<Object, FieldAndMethods> hashtable3 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, FieldAndMethods>(4);
                    if (bl) {
                        this.staticFieldAndMethods = hashtable;
                    } else {
                        this.fieldAndMethods = hashtable;
                    }
                }
                hashtable.put(object, fieldAndMethods);
                ((Hashtable)object2).put(object, fieldAndMethods);
                continue;
            }
            if (serializable instanceof Field) {
                object4 = (Field)((Object)serializable);
                if (!((Field)object4).getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                ((Hashtable)object2).put(object, field);
                continue;
            }
            Kit.codeBug();
        }
        for (n = 0; n != 2; ++n) {
            boolean bl = n == 0;
            Hashtable hashtable4 = bl ? this.staticMembers : this.members;
            Hashtable hashtable5 = new Hashtable();
            object2 = hashtable4.keys();
            while (object2.hasMoreElements()) {
                Object object5;
                object = (String)object2.nextElement();
                boolean bl2 = ((String)object).startsWith("get");
                boolean bl3 = ((String)object).startsWith("set");
                boolean bl4 = ((String)object).startsWith("is");
                if (!bl2 && !bl4 && !bl3 || ((String)((Object)(hashtable = ((String)object).substring(bl4 ? 2 : 3)))).length() == 0) continue;
                Object object6 = hashtable;
                char c = ((String)((Object)hashtable)).charAt(0);
                if (Character.isUpperCase(c)) {
                    if (((String)((Object)hashtable)).length() == 1) {
                        object6 = ((String)((Object)hashtable)).toLowerCase();
                    } else {
                        char c2 = ((String)((Object)hashtable)).charAt(1);
                        if (!Character.isUpperCase(c2)) {
                            object6 = Character.toLowerCase(c) + ((String)((Object)hashtable)).substring(1);
                        }
                    }
                }
                if (hashtable4.containsKey(object6) || hashtable5.containsKey(object6)) continue;
                MemberBox memberBox = null;
                memberBox = this.findGetter(bl, hashtable4, "get", (String)((Object)hashtable));
                if (memberBox == null) {
                    memberBox = this.findGetter(bl, hashtable4, "is", (String)((Object)hashtable));
                }
                MemberBox memberBox2 = null;
                NativeJavaMethod nativeJavaMethod = null;
                String string = "set".concat((String)((Object)hashtable));
                if (hashtable4.containsKey(string) && (object5 = hashtable4.get(string)) instanceof NativeJavaMethod) {
                    NativeJavaMethod nativeJavaMethod2 = (NativeJavaMethod)object5;
                    if (memberBox != null) {
                        Class<?> clazz = memberBox.method().getReturnType();
                        memberBox2 = JavaMembers.extractSetMethod(clazz, nativeJavaMethod2.methods, bl);
                    } else {
                        memberBox2 = JavaMembers.extractSetMethod(nativeJavaMethod2.methods, bl);
                    }
                    if (nativeJavaMethod2.methods.length > 1) {
                        nativeJavaMethod = nativeJavaMethod2;
                    }
                }
                object5 = new BeanProperty(memberBox, memberBox2, nativeJavaMethod);
                hashtable5.put(object6, object5);
            }
            object2 = hashtable5.keys();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                Object v = hashtable5.get(object);
                hashtable4.put(object, v);
            }
        }
        Constructor<?>[] constructorArray = this.cl.getConstructors();
        this.ctors = new MemberBox[constructorArray.length];
        for (int j = 0; j != constructorArray.length; ++j) {
            this.ctors[j] = new MemberBox(constructorArray[j]);
        }
    }

    private MemberBox findGetter(boolean bl, Hashtable hashtable, String string, String string2) {
        Object v;
        String string3 = string.concat(string2);
        if (hashtable.containsKey(string3) && (v = hashtable.get(string3)) instanceof NativeJavaMethod) {
            NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)v;
            return JavaMembers.extractGetMethod(nativeJavaMethod.methods, bl);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (int j = 0; j < memberBoxArray.length; ++j) {
            MemberBox memberBox = memberBoxArray[j];
            if (memberBox.argTypes.length != 0 || bl && !memberBox.isStatic()) continue;
            Class<?> clazz = memberBox.method().getReturnType();
            if (clazz == Void.TYPE) break;
            return memberBox;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class clazz, MemberBox[] memberBoxArray, boolean bl) {
        for (int j = 1; j <= 2; ++j) {
            for (int k = 0; k < memberBoxArray.length; ++k) {
                Class[] classArray;
                MemberBox memberBox = memberBoxArray[k];
                if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || (classArray = memberBox.argTypes).length != 1) continue;
                if (j == 1) {
                    if (classArray[0] != clazz) continue;
                    return memberBox;
                }
                if (j != 2) {
                    Kit.codeBug();
                }
                if (!classArray[0].isAssignableFrom(clazz)) continue;
                return memberBox;
            }
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (int j = 0; j < memberBoxArray.length; ++j) {
            MemberBox memberBox = memberBoxArray[j];
            if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || memberBox.argTypes.length != 1) continue;
            return memberBox;
        }
        return null;
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            return null;
        }
        int n = hashtable.size();
        Hashtable<String, FieldAndMethods> hashtable3 = new Hashtable<String, FieldAndMethods>(n);
        Enumeration enumeration = hashtable.elements();
        while (n-- > 0) {
            FieldAndMethods fieldAndMethods = (FieldAndMethods)enumeration.nextElement();
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(scriptable, fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashtable3.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashtable3;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class clazz, Class clazz2) {
        JavaMembers javaMembers;
        ClassCache classCache = ClassCache.get(scriptable);
        Hashtable hashtable = classCache.classTable;
        Class clazz3 = clazz;
        while (true) {
            if ((javaMembers = (JavaMembers)hashtable.get(clazz3)) != null) {
                return javaMembers;
            }
            try {
                javaMembers = new JavaMembers(classCache.scope, clazz3);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    clazz3 = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    if (clazz3.isInterface()) {
                        clazz4 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                clazz3 = clazz4;
                continue;
            }
            break;
        }
        if (classCache.isCachingEnabled()) {
            hashtable.put(clazz3, javaMembers);
        }
        return javaMembers;
    }

    RuntimeException reportMemberNotFound(String string) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string);
    }

    private static final class MethodSignature {
        private final String name;
        private final Class[] args;

        private MethodSignature(String string, Class[] classArray) {
            this.name = string;
            this.args = classArray;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object object) {
            if (object instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)object;
                return methodSignature.name.equals(this.name) && Arrays.equals(this.args, methodSignature.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

