/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.VMBridge;

final class MemberBox
implements Serializable {
    static final long serialVersionUID = 6358550398665688245L;
    private static final Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private transient Member memberObject;
    transient Class[] argTypes;

    MemberBox(Method method) {
        this.init(method);
    }

    MemberBox(Constructor constructor) {
        this.init(constructor);
    }

    private void init(Method method) {
        this.memberObject = method;
        this.argTypes = method.getParameterTypes();
    }

    private void init(Constructor constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
    }

    Method method() {
        return (Method)this.memberObject;
    }

    Constructor ctor() {
        return (Constructor)this.memberObject;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    String getName() {
        return this.memberObject.getName();
    }

    Class getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String toJavaDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isMethod()) {
            Method method = this.method();
            stringBuffer.append(method.getReturnType());
            stringBuffer.append(' ');
            stringBuffer.append(method.getName());
        } else {
            Constructor constructor = this.ctor();
            String string = constructor.getDeclaringClass().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(JavaMembers.liveConnectSignature(this.argTypes));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }

    Object invoke(Object object, Object[] objectArray) {
        Method method = this.method();
        try {
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Method method2 = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (method2 != null) {
                    this.memberObject = method2;
                    method = method2;
                } else if (!VMBridge.instance.tryToMakeAccessible(method)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    Object newInstance(Object[] objectArray) {
        Constructor constructor = this.ctor();
        try {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!VMBridge.instance.tryToMakeAccessible(constructor)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    private static Method searchAccessibleMethod(Method method, Class[] classArray) {
        Class<?> clazz;
        int n = method.getModifiers();
        if (Modifier.isPublic(n) && !Modifier.isStatic(n) && !Modifier.isPublic((clazz = method.getDeclaringClass()).getModifiers())) {
            String string = method.getName();
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n2 = classArray2.length;
            for (int j = 0; j != n2; ++j) {
                Class<?> clazz2 = classArray2[j];
                if (!Modifier.isPublic(clazz2.getModifiers())) continue;
                try {
                    return clazz2.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((clazz = clazz.getSuperclass()) != null) {
                if (!Modifier.isPublic(clazz.getModifiers())) continue;
                try {
                    Method method2 = clazz.getMethod(string, classArray);
                    n2 = method2.getModifiers();
                    if (!Modifier.isPublic(n2) || Modifier.isStatic(n2)) continue;
                    return method2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Member member = MemberBox.readMember(objectInputStream);
        if (member instanceof Method) {
            this.init((Method)member);
        } else {
            this.init((Constructor)member);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        MemberBox.writeMember(objectOutputStream, this.memberObject);
    }

    private static void writeMember(ObjectOutputStream objectOutputStream, Member member) throws IOException {
        if (member == null) {
            objectOutputStream.writeBoolean(false);
            return;
        }
        objectOutputStream.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        objectOutputStream.writeBoolean(member instanceof Method);
        objectOutputStream.writeObject(member.getName());
        objectOutputStream.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            MemberBox.writeParameters(objectOutputStream, ((Method)member).getParameterTypes());
        } else {
            MemberBox.writeParameters(objectOutputStream, ((Constructor)member).getParameterTypes());
        }
    }

    private static Member readMember(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!objectInputStream.readBoolean()) {
            return null;
        }
        boolean bl = objectInputStream.readBoolean();
        String string = (String)objectInputStream.readObject();
        Class clazz = (Class)objectInputStream.readObject();
        Class[] classArray = MemberBox.readParameters(objectInputStream);
        try {
            if (bl) {
                return clazz.getMethod(string, classArray);
            }
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot find member: " + noSuchMethodException);
        }
    }

    private static void writeParameters(ObjectOutputStream objectOutputStream, Class[] classArray) throws IOException {
        objectOutputStream.writeShort(classArray.length);
        block0: for (int j = 0; j < classArray.length; ++j) {
            Class clazz = classArray[j];
            boolean bl = clazz.isPrimitive();
            objectOutputStream.writeBoolean(bl);
            if (!bl) {
                objectOutputStream.writeObject(clazz);
                continue;
            }
            for (int k = 0; k < primitives.length; ++k) {
                if (!clazz.equals(primitives[k])) continue;
                objectOutputStream.writeByte(k);
                continue block0;
            }
            throw new IllegalArgumentException("Primitive " + clazz + " not found");
        }
    }

    private static Class[] readParameters(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[objectInputStream.readShort()];
        for (int j = 0; j < classArray.length; ++j) {
            classArray[j] = !objectInputStream.readBoolean() ? (Class)objectInputStream.readObject() : primitives[objectInputStream.readByte()];
        }
        return classArray;
    }
}

