/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    static final long serialVersionUID = -3440381785576412928L;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;
    private String functionName;

    NativeJavaMethod(MemberBox[] memberBoxArray) {
        this.functionName = memberBoxArray[0].getName();
        this.methods = memberBoxArray;
    }

    NativeJavaMethod(MemberBox memberBox, String string) {
        this.functionName = string;
        this.methods = new MemberBox[]{memberBox};
    }

    public NativeJavaMethod(Method method, String string) {
        this(new MemberBox(method), string);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j != objectArray.length; ++j) {
            String string;
            Object object = objectArray[j];
            if (object == null) {
                string = "null";
            } else if (object instanceof Boolean) {
                string = "boolean";
            } else if (object instanceof String) {
                string = "string";
            } else if (object instanceof Number) {
                string = "number";
            } else if (object instanceof Scriptable) {
                if (object instanceof Undefined) {
                    string = "undefined";
                } else if (object instanceof Wrapper) {
                    Object object2 = ((Wrapper)object).unwrap();
                    string = object2.getClass().getName();
                } else {
                    string = object instanceof Function ? "function" : "object";
                }
            } else {
                string = JavaMembers.javaSignature(object.getClass());
            }
            if (j != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    String decompile(int n, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = 0 != (n2 & 1);
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {");
        }
        stringBuffer.append("/*\n");
        stringBuffer.append(this.toString());
        stringBuffer.append(bl ? "*/\n" : "*/}\n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.methods.length;
        for (int j = 0; j != n; ++j) {
            Method method = this.methods[j].method();
            stringBuffer.append(JavaMembers.javaSignature(method.getReturnType()));
            stringBuffer.append(' ');
            stringBuffer.append(method.getName());
            stringBuffer.append(JavaMembers.liveConnectSignature(this.methods[j].argTypes));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Object object2;
        Object object3;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int n = NativeJavaMethod.findFunction(context, this.methods, objectArray);
        if (n < 0) {
            Class<?> clazz = this.methods[0].method().getDeclaringClass();
            String string = clazz.getName() + '.' + this.getFunctionName() + '(' + NativeJavaMethod.scriptSignature(objectArray) + ')';
            throw Context.reportRuntimeError1("msg.java.no_such_method", string);
        }
        MemberBox memberBox = this.methods[n];
        Class[] classArray = memberBox.argTypes;
        Object[] objectArray2 = objectArray;
        for (int j = 0; j < objectArray.length; ++j) {
            object3 = objectArray[j];
            object2 = Context.jsToJava(object3, classArray[j]);
            if (object2 == object3) continue;
            if (objectArray2 == objectArray) {
                objectArray = (Object[])objectArray.clone();
            }
            objectArray[j] = object2;
        }
        if (memberBox.isStatic()) {
            object = null;
        } else {
            object3 = scriptable2;
            object2 = memberBox.getDeclaringClass();
            while (true) {
                if (object3 == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(scriptable2), ((Class)object2).getName());
                }
                if (object3 instanceof Wrapper && ((Class)object2).isInstance(object = ((Wrapper)object3).unwrap())) break;
                object3 = object3.getPrototype();
            }
        }
        object3 = memberBox.invoke(object, objectArray);
        object2 = memberBox.method().getReturnType();
        Object object4 = context.getWrapFactory().wrap(context, scriptable, object3, (Class)object2);
        if (object4 == null && object2 == Void.TYPE) {
            object4 = Undefined.instance;
        }
        return object4;
    }

    static int findFunction(Context context, MemberBox[] memberBoxArray, Object[] objectArray) {
        if (memberBoxArray.length == 0) {
            return -1;
        }
        if (memberBoxArray.length == 1) {
            MemberBox memberBox = memberBoxArray[0];
            Class[] classArray = memberBox.argTypes;
            int n = classArray.length;
            if (n != objectArray.length) {
                return -1;
            }
            for (int j = 0; j != n; ++j) {
                if (NativeJavaObject.canConvert(objectArray[j], classArray[j])) continue;
                return -1;
            }
            return 0;
        }
        int n = -1;
        int[] nArray = null;
        int n2 = 0;
        block1: for (int j = 0; j < memberBoxArray.length; ++j) {
            int n3;
            MemberBox memberBox = memberBoxArray[j];
            Class[] classArray = memberBox.argTypes;
            if (classArray.length != objectArray.length) continue;
            for (n3 = 0; n3 < classArray.length; ++n3) {
                if (!NativeJavaObject.canConvert(objectArray[n3], classArray[n3])) continue block1;
            }
            if (n < 0) {
                n = j;
                continue;
            }
            n3 = 0;
            int n4 = 0;
            for (int k = -1; k != n2; ++k) {
                int n5 = k == -1 ? n : nArray[k];
                MemberBox memberBox2 = memberBoxArray[n5];
                int n6 = NativeJavaMethod.preferSignature(objectArray, classArray, memberBox2.argTypes);
                if (n6 == 3) break;
                if (n6 == 1) {
                    ++n3;
                    continue;
                }
                if (n6 == 2) {
                    ++n4;
                    continue;
                }
                if (n6 != 0) {
                    Kit.codeBug();
                }
                if (!memberBox2.isStatic() || !memberBox2.getDeclaringClass().isAssignableFrom(memberBox.getDeclaringClass())) continue block1;
                if (k == -1) {
                    n = j;
                    continue block1;
                }
                nArray[k] = j;
                continue block1;
            }
            if (n3 == 1 + n2) {
                n = j;
                n2 = 0;
                continue;
            }
            if (n4 == 1 + n2) continue;
            if (nArray == null) {
                nArray = new int[memberBoxArray.length - 1];
            }
            nArray[n2] = j;
            ++n2;
        }
        if (n < 0) {
            return -1;
        }
        if (n2 == 0) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = -1; j != n2; ++j) {
            int n7 = j == -1 ? n : nArray[j];
            stringBuffer.append("\n    ");
            stringBuffer.append(memberBoxArray[n7].toJavaDeclaration());
        }
        MemberBox memberBox = memberBoxArray[n];
        String string = memberBox.getName();
        String string2 = memberBox.getDeclaringClass().getName();
        if (memberBoxArray[0].isMethod()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", string, NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", string2, string, NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString());
    }

    private static int preferSignature(Object[] objectArray, Class[] classArray, Class[] classArray2) {
        int n = 0;
        for (int j = 0; j < objectArray.length; ++j) {
            int n2;
            Class clazz = classArray[j];
            Class clazz2 = classArray2[j];
            if (clazz == clazz2) continue;
            Object object = objectArray[j];
            int n3 = NativeJavaObject.getConversionWeight(object, clazz);
            int n4 = n3 < (n2 = NativeJavaObject.getConversionWeight(object, clazz2)) ? 1 : (n3 > n2 ? 2 : (n3 == 0 ? (clazz.isAssignableFrom(clazz2) ? 2 : (clazz2.isAssignableFrom(clazz) ? 1 : 3)) : 3));
            if ((n |= n4) == 3) break;
        }
        return n;
    }

    private static void printDebug(String string, MemberBox memberBox, Object[] objectArray) {
    }
}

