/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

final class NativeMath
extends IdScriptableObject {
    static final long serialVersionUID = -8838847185801131569L;
    private static final Object MATH_TAG = new Object();
    private static final int Id_toSource = 1;
    private static final int Id_abs = 2;
    private static final int Id_acos = 3;
    private static final int Id_asin = 4;
    private static final int Id_atan = 5;
    private static final int Id_atan2 = 6;
    private static final int Id_ceil = 7;
    private static final int Id_cos = 8;
    private static final int Id_exp = 9;
    private static final int Id_floor = 10;
    private static final int Id_log = 11;
    private static final int Id_max = 12;
    private static final int Id_min = 13;
    private static final int Id_pow = 14;
    private static final int Id_random = 15;
    private static final int Id_round = 16;
    private static final int Id_sin = 17;
    private static final int Id_sqrt = 18;
    private static final int Id_tan = 19;
    private static final int LAST_METHOD_ID = 19;
    private static final int Id_E = 20;
    private static final int Id_PI = 21;
    private static final int Id_LN10 = 22;
    private static final int Id_LN2 = 23;
    private static final int Id_LOG2E = 24;
    private static final int Id_LOG10E = 25;
    private static final int Id_SQRT1_2 = 26;
    private static final int Id_SQRT2 = 27;
    private static final int MAX_ID = 27;

    static void init(Scriptable scriptable, boolean bl) {
        NativeMath nativeMath = new NativeMath();
        nativeMath.activatePrototypeMap(27);
        nativeMath.setPrototype(NativeMath.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        if (bl) {
            nativeMath.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "Math", nativeMath, 2);
    }

    private NativeMath() {
    }

    public String getClassName() {
        return "Math";
    }

    protected void initPrototypeId(int n) {
        if (n <= 19) {
            String string;
            int n2;
            switch (n) {
                case 1: {
                    n2 = 0;
                    string = "toSource";
                    break;
                }
                case 2: {
                    n2 = 1;
                    string = "abs";
                    break;
                }
                case 3: {
                    n2 = 1;
                    string = "acos";
                    break;
                }
                case 4: {
                    n2 = 1;
                    string = "asin";
                    break;
                }
                case 5: {
                    n2 = 1;
                    string = "atan";
                    break;
                }
                case 6: {
                    n2 = 2;
                    string = "atan2";
                    break;
                }
                case 7: {
                    n2 = 1;
                    string = "ceil";
                    break;
                }
                case 8: {
                    n2 = 1;
                    string = "cos";
                    break;
                }
                case 9: {
                    n2 = 1;
                    string = "exp";
                    break;
                }
                case 10: {
                    n2 = 1;
                    string = "floor";
                    break;
                }
                case 11: {
                    n2 = 1;
                    string = "log";
                    break;
                }
                case 12: {
                    n2 = 2;
                    string = "max";
                    break;
                }
                case 13: {
                    n2 = 2;
                    string = "min";
                    break;
                }
                case 14: {
                    n2 = 2;
                    string = "pow";
                    break;
                }
                case 15: {
                    n2 = 0;
                    string = "random";
                    break;
                }
                case 16: {
                    n2 = 1;
                    string = "round";
                    break;
                }
                case 17: {
                    n2 = 1;
                    string = "sin";
                    break;
                }
                case 18: {
                    n2 = 1;
                    string = "sqrt";
                    break;
                }
                case 19: {
                    n2 = 1;
                    string = "tan";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(n));
                }
            }
            this.initPrototypeMethod(MATH_TAG, n, string, n2);
        } else {
            String string;
            double d;
            switch (n) {
                case 20: {
                    d = Math.E;
                    string = "E";
                    break;
                }
                case 21: {
                    d = Math.PI;
                    string = "PI";
                    break;
                }
                case 22: {
                    d = 2.302585092994046;
                    string = "LN10";
                    break;
                }
                case 23: {
                    d = 0.6931471805599453;
                    string = "LN2";
                    break;
                }
                case 24: {
                    d = 1.4426950408889634;
                    string = "LOG2E";
                    break;
                }
                case 25: {
                    d = 0.4342944819032518;
                    string = "LOG10E";
                    break;
                }
                case 26: {
                    d = 0.7071067811865476;
                    string = "SQRT1_2";
                    break;
                }
                case 27: {
                    d = 1.4142135623730951;
                    string = "SQRT2";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(n));
                }
            }
            this.initPrototypeValue(n, string, ScriptRuntime.wrapNumber(d), 7);
        }
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d;
        if (!idFunctionObject.hasTag(MATH_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        block0 : switch (n) {
            case 1: {
                return "Math";
            }
            case 2: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = d == 0.0 ? 0.0 : (d < 0.0 ? -d : d);
                break;
            }
            case 3: 
            case 4: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                if (d == d && -1.0 <= d && d <= 1.0) {
                    d = n == 3 ? Math.acos(d) : Math.asin(d);
                    break;
                }
                d = Double.NaN;
                break;
            }
            case 5: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = Math.atan(d);
                break;
            }
            case 6: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = Math.atan2(d, ScriptRuntime.toNumber(objectArray, 1));
                break;
            }
            case 7: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = Math.ceil(d);
                break;
            }
            case 8: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY ? Double.NaN : Math.cos(d);
                break;
            }
            case 9: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = d == Double.POSITIVE_INFINITY ? d : (d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d));
                break;
            }
            case 10: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = Math.floor(d);
                break;
            }
            case 11: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = d < 0.0 ? Double.NaN : Math.log(d);
                break;
            }
            case 12: 
            case 13: {
                d = n == 12 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                for (int j = 0; j != objectArray.length; ++j) {
                    double d2 = ScriptRuntime.toNumber(objectArray[j]);
                    if (d2 != d2) {
                        d = d2;
                        break block0;
                    }
                    d = n == 12 ? Math.max(d, d2) : Math.min(d, d2);
                }
                break;
            }
            case 14: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = this.js_pow(d, ScriptRuntime.toNumber(objectArray, 1));
                break;
            }
            case 15: {
                d = Math.random();
                break;
            }
            case 16: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) break;
                long l = Math.round(d);
                if (l != 0L) {
                    d = l;
                    break;
                }
                if (d < 0.0) {
                    d = ScriptRuntime.negativeZero;
                    break;
                }
                if (d == 0.0) break;
                d = 0.0;
                break;
            }
            case 17: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY ? Double.NaN : Math.sin(d);
                break;
            }
            case 18: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = Math.sqrt(d);
                break;
            }
            case 19: {
                d = ScriptRuntime.toNumber(objectArray, 0);
                d = Math.tan(d);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
        return ScriptRuntime.wrapNumber(d);
    }

    private double js_pow(double d, double d2) {
        double d3;
        if (d2 != d2) {
            d3 = d2;
        } else if (d2 == 0.0) {
            d3 = 1.0;
        } else if (d == 0.0) {
            long l;
            d3 = 1.0 / d > 0.0 ? (d2 > 0.0 ? 0.0 : Double.POSITIVE_INFINITY) : ((double)(l = (long)d2) == d2 && (l & 1L) != 0L ? (d2 > 0.0 ? -0.0 : Double.NEGATIVE_INFINITY) : (d2 > 0.0 ? 0.0 : Double.POSITIVE_INFINITY));
        } else {
            d3 = Math.pow(d, d2);
            if (d3 != d3) {
                if (d2 == Double.POSITIVE_INFINITY) {
                    if (d < -1.0 || 1.0 < d) {
                        d3 = Double.POSITIVE_INFINITY;
                    } else if (-1.0 < d && d < 1.0) {
                        d3 = 0.0;
                    }
                } else if (d2 == Double.NEGATIVE_INFINITY) {
                    if (d < -1.0 || 1.0 < d) {
                        d3 = 0.0;
                    } else if (-1.0 < d && d < 1.0) {
                        d3 = Double.POSITIVE_INFINITY;
                    }
                } else if (d == Double.POSITIVE_INFINITY) {
                    d3 = d2 > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                } else if (d == Double.NEGATIVE_INFINITY) {
                    long l = (long)d2;
                    d3 = (double)l == d2 && (l & 1L) != 0L ? (d2 > 0.0 ? Double.NEGATIVE_INFINITY : -0.0) : (d2 > 0.0 ? Double.POSITIVE_INFINITY : 0.0);
                }
            }
        }
        return d3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 1: {
                if (string.charAt(0) != 'E') break;
                return 20;
            }
            case 2: {
                if (string.charAt(0) != 'P' || string.charAt(1) != 'I') break;
                return 21;
            }
            case 3: {
                switch (string.charAt(0)) {
                    case 'L': {
                        if (string.charAt(2) != '2' || string.charAt(1) != 'N') break;
                        return 23;
                    }
                    case 'a': {
                        if (string.charAt(2) != 's' || string.charAt(1) != 'b') break;
                        return 2;
                    }
                    case 'c': {
                        if (string.charAt(2) != 's' || string.charAt(1) != 'o') break;
                        return 8;
                    }
                    case 'e': {
                        if (string.charAt(2) != 'p' || string.charAt(1) != 'x') break;
                        return 9;
                    }
                    case 'l': {
                        if (string.charAt(2) != 'g' || string.charAt(1) != 'o') break;
                        return 11;
                    }
                    case 'm': {
                        char c = string.charAt(2);
                        if (c == 'n') {
                            if (string.charAt(1) != 'i') break;
                            return 13;
                        }
                        if (c != 'x' || string.charAt(1) != 'a') break;
                        return 12;
                    }
                    case 'p': {
                        if (string.charAt(2) != 'w' || string.charAt(1) != 'o') break;
                        return 14;
                    }
                    case 's': {
                        if (string.charAt(2) != 'n' || string.charAt(1) != 'i') break;
                        return 17;
                    }
                    case 't': {
                        if (string.charAt(2) != 'n' || string.charAt(1) != 'a') break;
                        return 19;
                    }
                }
                break;
            }
            case 4: {
                switch (string.charAt(1)) {
                    case 'N': {
                        string2 = "LN10";
                        n = 22;
                        break block0;
                    }
                    case 'c': {
                        string2 = "acos";
                        n = 3;
                        break block0;
                    }
                    case 'e': {
                        string2 = "ceil";
                        n = 7;
                        break block0;
                    }
                    case 'q': {
                        string2 = "sqrt";
                        n = 18;
                        break block0;
                    }
                    case 's': {
                        string2 = "asin";
                        n = 4;
                        break block0;
                    }
                    case 't': {
                        string2 = "atan";
                        n = 5;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'L': {
                        string2 = "LOG2E";
                        n = 24;
                        break block0;
                    }
                    case 'S': {
                        string2 = "SQRT2";
                        n = 27;
                        break block0;
                    }
                    case 'a': {
                        string2 = "atan2";
                        n = 6;
                        break block0;
                    }
                    case 'f': {
                        string2 = "floor";
                        n = 10;
                        break block0;
                    }
                    case 'r': {
                        string2 = "round";
                        n = 16;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'L') {
                    string2 = "LOG10E";
                    n = 25;
                    break;
                }
                if (c != 'r') break;
                string2 = "random";
                n = 15;
                break;
            }
            case 7: {
                string2 = "SQRT1_2";
                n = 26;
                break;
            }
            case 8: {
                string2 = "toSource";
                n = 1;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

