/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.Block;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class Optimizer {
    static final int NoType = 0;
    static final int NumberType = 1;
    static final int AnyType = 3;
    private boolean inDirectCallFunction;
    OptFunctionNode theFunction;
    private boolean parameterUsedInNumberContext;

    Optimizer() {
    }

    void optimize(ScriptOrFnNode scriptOrFnNode) {
        int n = scriptOrFnNode.getFunctionCount();
        for (int j = 0; j != n; ++j) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode, j);
            this.optimizeFunction(optFunctionNode);
        }
    }

    private void optimizeFunction(OptFunctionNode optFunctionNode) {
        if (optFunctionNode.fnode.requiresActivation()) {
            return;
        }
        this.inDirectCallFunction = optFunctionNode.isTargetOfDirectCall();
        this.theFunction = optFunctionNode;
        ObjArray objArray = new ObjArray();
        Optimizer.buildStatementList_r(optFunctionNode.fnode, objArray);
        Object[] objectArray = new Node[objArray.size()];
        objArray.toArray(objectArray);
        Block.runFlowAnalyzes(optFunctionNode, (Node[])objectArray);
        if (!optFunctionNode.fnode.requiresActivation()) {
            this.parameterUsedInNumberContext = false;
            for (int j = 0; j < objectArray.length; ++j) {
                this.rewriteForNumberVariables((Node)objectArray[j]);
            }
            optFunctionNode.setParameterNumberContext(this.parameterUsedInNumberContext);
        }
    }

    private void markDCPNumberContext(Node node) {
        int n;
        if (this.inDirectCallFunction && node.getType() == 54 && this.theFunction.isParameter(n = this.theFunction.getVarIndex(node))) {
            this.parameterUsedInNumberContext = true;
        }
    }

    private boolean convertParameter(Node node) {
        int n;
        if (this.inDirectCallFunction && node.getType() == 54 && this.theFunction.isParameter(n = this.theFunction.getVarIndex(node))) {
            node.removeProp(8);
            return true;
        }
        return false;
    }

    private int rewriteForNumberVariables(Node node) {
        switch (node.getType()) {
            case 129: {
                Node node2 = node.getFirstChild();
                int n = this.rewriteForNumberVariables(node2);
                if (n == 1) {
                    node.putIntProp(8, 0);
                }
                return 0;
            }
            case 39: {
                node.putIntProp(8, 0);
                return 1;
            }
            case 54: {
                int n = this.theFunction.getVarIndex(node);
                if (this.inDirectCallFunction && this.theFunction.isParameter(n)) {
                    node.putIntProp(8, 0);
                    return 1;
                }
                if (this.theFunction.isNumberVar(n)) {
                    node.putIntProp(8, 0);
                    return 1;
                }
                return 0;
            }
            case 102: 
            case 103: {
                Node node3 = node.getFirstChild();
                if (node3.getType() == 54) {
                    int n = this.theFunction.getVarIndex(node3);
                    if (this.theFunction.isNumberVar(n)) {
                        node.putIntProp(8, 0);
                        this.markDCPNumberContext(node3);
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            case 55: {
                Node node4 = node.getFirstChild();
                Node node5 = node4.getNext();
                int n = this.rewriteForNumberVariables(node5);
                int n2 = this.theFunction.getVarIndex(node);
                if (this.inDirectCallFunction && this.theFunction.isParameter(n2)) {
                    if (n == 1) {
                        if (!this.convertParameter(node5)) {
                            node.putIntProp(8, 0);
                            return 1;
                        }
                        this.markDCPNumberContext(node5);
                        return 0;
                    }
                    return n;
                }
                if (this.theFunction.isNumberVar(n2)) {
                    if (n != 1) {
                        node.removeChild(node5);
                        node.addChildToBack(new Node(146, node5));
                    }
                    node.putIntProp(8, 0);
                    this.markDCPNumberContext(node5);
                    return 1;
                }
                if (n == 1 && !this.convertParameter(node5)) {
                    node.removeChild(node5);
                    node.addChildToBack(new Node(145, node5));
                }
                return 0;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                Node node6 = node.getFirstChild();
                Node node7 = node6.getNext();
                int n = this.rewriteForNumberVariables(node6);
                int n3 = this.rewriteForNumberVariables(node7);
                this.markDCPNumberContext(node6);
                this.markDCPNumberContext(node7);
                if (this.convertParameter(node6)) {
                    if (this.convertParameter(node7)) {
                        return 0;
                    }
                    if (n3 == 1) {
                        node.putIntProp(8, 2);
                    }
                } else if (this.convertParameter(node7)) {
                    if (n == 1) {
                        node.putIntProp(8, 1);
                    }
                } else if (n == 1) {
                    if (n3 == 1) {
                        node.putIntProp(8, 0);
                    } else {
                        node.putIntProp(8, 1);
                    }
                } else if (n3 == 1) {
                    node.putIntProp(8, 2);
                }
                return 0;
            }
            case 21: {
                Node node8 = node.getFirstChild();
                Node node9 = node8.getNext();
                int n = this.rewriteForNumberVariables(node8);
                int n4 = this.rewriteForNumberVariables(node9);
                if (this.convertParameter(node8)) {
                    if (this.convertParameter(node9)) {
                        return 0;
                    }
                    if (n4 == 1) {
                        node.putIntProp(8, 2);
                    }
                } else if (this.convertParameter(node9)) {
                    if (n == 1) {
                        node.putIntProp(8, 1);
                    }
                } else if (n == 1) {
                    if (n4 == 1) {
                        node.putIntProp(8, 0);
                        return 1;
                    }
                    node.putIntProp(8, 1);
                } else if (n4 == 1) {
                    node.putIntProp(8, 2);
                }
                return 0;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Node node10 = node.getFirstChild();
                Node node11 = node10.getNext();
                int n = this.rewriteForNumberVariables(node10);
                int n5 = this.rewriteForNumberVariables(node11);
                this.markDCPNumberContext(node10);
                this.markDCPNumberContext(node11);
                if (n == 1) {
                    if (n5 == 1) {
                        node.putIntProp(8, 0);
                        return 1;
                    }
                    if (!this.convertParameter(node11)) {
                        node.removeChild(node11);
                        node.addChildToBack(new Node(146, node11));
                        node.putIntProp(8, 0);
                    }
                    return 1;
                }
                if (n5 == 1) {
                    if (!this.convertParameter(node10)) {
                        node.removeChild(node10);
                        node.addChildToFront(new Node(146, node10));
                        node.putIntProp(8, 0);
                    }
                    return 1;
                }
                if (!this.convertParameter(node10)) {
                    node.removeChild(node10);
                    node.addChildToFront(new Node(146, node10));
                }
                if (!this.convertParameter(node11)) {
                    node.removeChild(node11);
                    node.addChildToBack(new Node(146, node11));
                }
                node.putIntProp(8, 0);
                return 1;
            }
            case 36: 
            case 136: {
                int n;
                int n6;
                Node node12 = node.getFirstChild();
                Node node13 = node12.getNext();
                Node node14 = node13.getNext();
                int n7 = this.rewriteForNumberVariables(node12);
                if (n7 == 1 && !this.convertParameter(node12)) {
                    node.removeChild(node12);
                    node.addChildToFront(new Node(145, node12));
                }
                if ((n6 = this.rewriteForNumberVariables(node13)) == 1) {
                    node.putIntProp(8, 1);
                    this.markDCPNumberContext(node13);
                }
                if ((n = this.rewriteForNumberVariables(node14)) == 1 && !this.convertParameter(node14)) {
                    node.removeChild(node14);
                    node.addChildToBack(new Node(145, node14));
                }
                return 0;
            }
            case 35: {
                int n;
                Node node15 = node.getFirstChild();
                Node node16 = node15.getNext();
                int n8 = this.rewriteForNumberVariables(node15);
                if (n8 == 1 && !this.convertParameter(node15)) {
                    node.removeChild(node15);
                    node.addChildToFront(new Node(145, node15));
                }
                if ((n = this.rewriteForNumberVariables(node16)) == 1 && !this.convertParameter(node16)) {
                    node.putIntProp(8, 2);
                }
                return 0;
            }
            case 37: {
                Node node17 = node.getFirstChild();
                if (node17.getType() == 35) {
                    this.rewriteAsObjectChildren(node17, node17.getFirstChild());
                } else {
                    this.rewriteForNumberVariables(node17);
                }
                OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(9);
                if (optFunctionNode != null) {
                    for (node17 = node17.getNext(); node17 != null; node17 = node17.getNext()) {
                        int n = this.rewriteForNumberVariables(node17);
                        if (n != 1) continue;
                        this.markDCPNumberContext(node17);
                    }
                } else {
                    this.rewriteAsObjectChildren(node, node17);
                }
                return 0;
            }
        }
        this.rewriteAsObjectChildren(node, node.getFirstChild());
        return 0;
    }

    private void rewriteAsObjectChildren(Node node, Node node2) {
        while (node2 != null) {
            Node node3 = node2.getNext();
            int n = this.rewriteForNumberVariables(node2);
            if (n == 1 && !this.convertParameter(node2)) {
                node.removeChild(node2);
                Node node4 = new Node(145, node2);
                if (node3 == null) {
                    node.addChildToBack(node4);
                } else {
                    node.addChildBefore(node4, node3);
                }
            }
            node2 = node3;
        }
    }

    private static void buildStatementList_r(Node node, ObjArray objArray) {
        int n = node.getType();
        if (n == 125 || n == 137 || n == 128 || n == 105) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Optimizer.buildStatementList_r(node2, objArray);
            }
        } else {
            objArray.add(node);
        }
    }
}

