/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;

class FileHeader
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -2858905404778259127L;
    private int pressLine = -1;
    private FileWindow fileWindow;

    public FileHeader(FileWindow fileWindow) {
        this.fileWindow = fileWindow;
        this.addMouseListener(this);
        this.update();
    }

    public void update() {
        FileTextArea fileTextArea = this.fileWindow.textArea;
        Font font = fileTextArea.getFont();
        this.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fileTextArea.getLineCount() + 1;
        String string = Integer.toString(n2);
        if (string.length() < 2) {
            string = "99";
        }
        Dimension dimension = new Dimension();
        dimension.width = fontMetrics.stringWidth(string) + 16;
        dimension.height = n2 * n + 100;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        FileTextArea fileTextArea = this.fileWindow.textArea;
        Font font = fileTextArea.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = this.getX();
        int n2 = fontMetrics.getMaxAscent();
        int n3 = fontMetrics.getHeight();
        int n4 = fileTextArea.getLineCount() + 1;
        String string = Integer.toString(n4);
        if (string.length() < 2) {
            string = "99";
        }
        int n5 = fontMetrics.stringWidth(string);
        int n6 = rectangle.y / n3;
        int n7 = (rectangle.y + rectangle.height) / n3 + 1;
        int n8 = this.getWidth();
        if (n7 > n4) {
            n7 = n4;
        }
        for (int j = n6; j < n7; ++j) {
            int n9 = -2;
            try {
                n9 = fileTextArea.getLineStartOffset(j);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            boolean bl = this.fileWindow.isBreakPoint(j + 1);
            String string2 = Integer.toString(j + 1) + " ";
            int n10 = fontMetrics.stringWidth(string2);
            int n11 = j * n3;
            graphics.setColor(Color.blue);
            graphics.drawString(string2, 0, n11 + n2);
            int n12 = n8 - n2;
            if (bl) {
                graphics.setColor(new Color(128, 0, 0));
                int n13 = n11 + n2 - 9;
                graphics.fillOval(n12, n13, 9, 9);
                graphics.drawOval(n12, n13, 8, 8);
                graphics.drawOval(n12, n13, 9, 9);
            }
            if (n9 != this.fileWindow.currentPos) continue;
            Polygon polygon = new Polygon();
            int n14 = n12;
            int n15 = n11 += n2 - 10;
            polygon.addPoint(n14, n15 + 3);
            polygon.addPoint(n14 + 5, n15 + 3);
            n12 = n14 + 5;
            while (n12 <= n14 + 10) {
                polygon.addPoint(n12, n11);
                ++n12;
                ++n11;
            }
            n12 = n14 + 9;
            while (n12 >= n14 + 5) {
                polygon.addPoint(n12, n11);
                --n12;
                ++n11;
            }
            polygon.addPoint(n14 + 5, n15 + 7);
            polygon.addPoint(n14, n15 + 7);
            graphics.setColor(Color.yellow);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Font font = this.fileWindow.textArea.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        this.pressLine = mouseEvent.getY() / n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this && (mouseEvent.getModifiers() & 0x10) != 0) {
            Font font;
            FontMetrics fontMetrics;
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = n3 / (n = (fontMetrics = this.getFontMetrics(font = this.fileWindow.textArea.getFont())).getHeight());
            if (n4 == this.pressLine) {
                this.fileWindow.toggleBreakPoint(n4 + 1);
            } else {
                this.pressLine = -1;
            }
        }
    }
}

