/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.tools.debugger.SwingGui;

class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui debugGui;
    private Vector expressions;
    private Vector values;

    public MyTableModel(SwingGui swingGui) {
        this.debugGui = swingGui;
        this.expressions = new Vector();
        this.values = new Vector();
        this.expressions.addElement("");
        this.values.addElement("");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.expressions.size();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.expressions.elementAt(n);
            }
            case 1: {
                return this.values.elementAt(n);
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                String string = object.toString();
                this.expressions.setElementAt(string, n);
                String string2 = "";
                if (string.length() > 0 && (string2 = this.debugGui.dim.eval(string)) == null) {
                    string2 = "";
                }
                this.values.setElementAt(string2, n);
                this.updateModel();
                if (n + 1 != this.expressions.size()) break;
                this.expressions.addElement("");
                this.values.addElement("");
                this.fireTableRowsInserted(n + 1, n + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        for (int j = 0; j < this.expressions.size(); ++j) {
            Object e = this.expressions.elementAt(j);
            String string = e.toString();
            String string2 = "";
            if (string.length() > 0) {
                string2 = this.debugGui.dim.eval(string);
                if (string2 == null) {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
            string2 = string2.replace('\n', ' ');
            this.values.setElementAt(string2, j);
        }
        this.fireTableDataChanged();
    }
}

